import os
import pickle
import random

def get_image_paths_and_labels_from_filelist(filelist_path):
    image_paths = []
    labels = []
    class_to_idx = {}
    
    with open(filelist_path, "r") as f:
        for line in f:
            relpath = line.strip()  # 파일 경로
            class_name = relpath.split("/")[0]  # 클래스 이름
            
            if class_name not in class_to_idx:
                class_to_idx[class_name] = len(class_to_idx)  # 클래스 레이블 부여

            image_paths.append(relpath)
            labels.append(class_to_idx[class_name])  # 클래스 레이블 저장
    
    return image_paths, labels, class_to_idx

def create_filtered_index_file(filelist_path, num_classes=10, output_path="imagenet_train_nclass_indices.p"):
    # 1. 전체 이미지 경로와 레이블을 얻는다.
    image_paths, labels, class_to_idx = get_image_paths_and_labels_from_filelist(filelist_path)
    
    # 2. 랜덤으로 10개의 클래스 선택
    unique_classes = np.unique(labels)
    selected_classes = random.sample(list(unique_classes), num_classes)
    print(f"Selected classes: {selected_classes}")

    # 3. 선택된 클래스에 해당하는 인덱스만 필터링
    selected_indices = [idx for idx, label in enumerate(labels) if label in selected_classes]
    
    # 4. 선택된 인덱스를 pickle 파일로 저장
    with open(output_path, "wb") as f:
        pickle.dump(selected_indices, f)

    print(f"Saved {len(selected_indices)} indices for the selected classes to {output_path}")

# 5. filelist.txt 경로에 있는 인덱스를 필터링하여 저장하기
filelist_path = "/data/ILSVRC2012/data/train/filelist.txt"  # 파일 경로에 맞게 수정
create_filtered_index_file(filelist_path, num_classes=10, output_path="data/imagenet_train_nclass_indices.p")
