# Copyright (c) 2024 ByteDance. All Rights Reserved.
import contextlib
import io
import json
import logging
import numpy as np
import os
import pycocotools.mask as mask_util
from fvcore.common.file_io import PathManager
from fvcore.common.timer import Timer

from detectron2.structures import Boxes, BoxMode, PolygonMasks
from detectron2.data import DatasetCatalog, MetadataCatalog

"""
This file contains functions to parse UVO dataset (YTVIS fromat) of
COCO-format annotations into dicts in "Detectron2 format".
"""

logger = logging.getLogger(__name__)

__all__ = ["load_ytvis_json", "register_tao_video"]

TAO_CATEGORIES = [
    {'isthing': 1, 'id': 2, 'name': 'aerosol_can'} ,
    {'isthing': 1, 'id': 4, 'name': 'airplane'} ,
    {'isthing': 1, 'id': 20, 'name': 'armchair'} ,
    {'isthing': 1, 'id': 27, 'name': 'atomizer'} ,
    {'isthing': 1, 'id': 31, 'name': 'ax'} ,
    {'isthing': 1, 'id': 32, 'name': 'baby_buggy'} ,
    {'isthing': 1, 'id': 34, 'name': 'backpack'} ,
    {'isthing': 1, 'id': 35, 'name': 'handbag'} ,
    {'isthing': 1, 'id': 36, 'name': 'suitcase'} ,
    {'isthing': 1, 'id': 41, 'name': 'ball'} ,
    {'isthing': 1, 'id': 43, 'name': 'balloon'} ,
    {'isthing': 1, 'id': 45, 'name': 'banana'} ,
    {'isthing': 1, 'id': 51, 'name': 'barbell'} ,
    {'isthing': 1, 'id': 58, 'name': 'baseball_bat'} ,
    {'isthing': 1, 'id': 61, 'name': 'basket'} ,
    {'isthing': 1, 'id': 62, 'name': 'basketball_hoop'} ,
    {'isthing': 1, 'id': 63, 'name': 'basketball'} ,
    {'isthing': 1, 'id': 74, 'name': 'beaker'} ,
    {'isthing': 1, 'id': 77, 'name': 'beanie'} ,
    {'isthing': 1, 'id': 78, 'name': 'bear'} ,
    {'isthing': 1, 'id': 79, 'name': 'bed'} ,
    {'isthing': 1, 'id': 80, 'name': 'bedspread'} ,
    {'isthing': 1, 'id': 81, 'name': 'cow'} ,
    {'isthing': 1, 'id': 83, 'name': 'beeper'} ,
    {'isthing': 1, 'id': 87, 'name': 'bell'} ,
    {'isthing': 1, 'id': 95, 'name': 'bicycle'} ,
    {'isthing': 1, 'id': 97, 'name': 'binder'} ,
    {'isthing': 1, 'id': 98, 'name': 'binoculars'} ,
    {'isthing': 1, 'id': 99, 'name': 'bird'} ,
    {'isthing': 1, 'id': 100, 'name': 'birdfeeder'} ,
    {'isthing': 1, 'id': 102, 'name': 'birdcage'} ,
    {'isthing': 1, 'id': 103, 'name': 'birdhouse'} ,
    {'isthing': 1, 'id': 106, 'name': 'biscuit_(bread)'} ,
    {'isthing': 1, 'id': 108, 'name': 'black_sheep'} ,
    {'isthing': 1, 'id': 110, 'name': 'blanket'} ,
    {'isthing': 1, 'id': 118, 'name': 'boat'} ,
    {'isthing': 1, 'id': 126, 'name': 'book'} ,
    {'isthing': 1, 'id': 129, 'name': 'booklet'} ,
    {'isthing': 1, 'id': 133, 'name': 'bottle'} ,
    {'isthing': 1, 'id': 136, 'name': 'bow_(weapon)'} ,
    {'isthing': 1, 'id': 139, 'name': 'bowl'} ,
    {'isthing': 1, 'id': 152, 'name': 'briefcase'} ,
    {'isthing': 1, 'id': 156, 'name': 'broom'} ,
    {'isthing': 1, 'id': 160, 'name': 'bucket'} ,
    {'isthing': 1, 'id': 162, 'name': 'bull'} ,
    {'isthing': 1, 'id': 170, 'name': 'bun'} ,
    {'isthing': 1, 'id': 172, 'name': 'buoy'} ,
    {'isthing': 1, 'id': 174, 'name': 'bus_(vehicle)'} ,
    {'isthing': 1, 'id': 175, 'name': 'business_card'} ,
    {'isthing': 1, 'id': 176, 'name': 'butcher_knife'} ,
    {'isthing': 1, 'id': 180, 'name': 'cab_(taxi)'} ,
    {'isthing': 1, 'id': 188, 'name': 'calf'} ,
    {'isthing': 1, 'id': 190, 'name': 'camel'} ,
    {'isthing': 1, 'id': 191, 'name': 'camera'} ,
    {'isthing': 1, 'id': 194, 'name': 'can'} ,
    {'isthing': 1, 'id': 197, 'name': 'candle'} ,
    {'isthing': 1, 'id': 202, 'name': 'canister'} ,
    {'isthing': 1, 'id': 204, 'name': 'canoe'} ,
    {'isthing': 1, 'id': 208, 'name': 'bottle_cap'} ,
    {'isthing': 1, 'id': 209, 'name': 'cape'} ,
    {'isthing': 1, 'id': 211, 'name': 'car_(automobile)'} ,
    {'isthing': 1, 'id': 212, 'name': 'railcar_(part_of_a_train)'} ,
    {'isthing': 1, 'id': 214, 'name': 'car_battery'} ,
    {'isthing': 1, 'id': 224, 'name': 'carton'} ,
    {'isthing': 1, 'id': 229, 'name': 'cat'} ,
    {'isthing': 1, 'id': 235, 'name': 'cellular_telephone'} ,
    {'isthing': 1, 'id': 236, 'name': 'chain_mail'} ,
    {'isthing': 1, 'id': 237, 'name': 'chair'} ,
    {'isthing': 1, 'id': 247, 'name': 'chicken_(animal)'} ,
    {'isthing': 1, 'id': 254, 'name': 'crisp_(potato_chip)'} ,
    {'isthing': 1, 'id': 267, 'name': 'cigarette'} ,
    {'isthing': 1, 'id': 268, 'name': 'cigarette_case'} ,
    {'isthing': 1, 'id': 274, 'name': 'clip'} ,
    {'isthing': 1, 'id': 275, 'name': 'clipboard'} ,
    {'isthing': 1, 'id': 280, 'name': 'clutch_bag'} ,
    {'isthing': 1, 'id': 282, 'name': 'coat'} ,
    {'isthing': 1, 'id': 283, 'name': 'coat_hanger'} ,
    {'isthing': 1, 'id': 289, 'name': 'coffee_table'} ,
    {'isthing': 1, 'id': 292, 'name': 'coin'} ,
    {'isthing': 1, 'id': 297, 'name': 'pacifier'} ,
    {'isthing': 1, 'id': 299, 'name': 'computer_keyboard'} ,
    {'isthing': 1, 'id': 301, 'name': 'cone'} ,
    {'isthing': 1, 'id': 302, 'name': 'control'} ,
    {'isthing': 1, 'id': 303, 'name': 'convertible_(automobile)'} ,
    {'isthing': 1, 'id': 308, 'name': 'cooler_(for_food)'} ,
    {'isthing': 1, 'id': 314, 'name': 'cornet'} ,
    {'isthing': 1, 'id': 324, 'name': 'crab_(animal)'} ,
    {'isthing': 1, 'id': 344, 'name': 'cube'} ,
    {'isthing': 1, 'id': 347, 'name': 'cup'} ,
    {'isthing': 1, 'id': 352, 'name': 'curtain'} ,
    {'isthing': 1, 'id': 353, 'name': 'cushion'} ,
    {'isthing': 1, 'id': 355, 'name': 'cutting_tool'} ,
    {'isthing': 1, 'id': 356, 'name': 'cylinder'} ,
    {'isthing': 1, 'id': 357, 'name': 'cymbal'} ,
    {'isthing': 1, 'id': 363, 'name': 'deer'} ,
    {'isthing': 1, 'id': 369, 'name': 'die'} ,
    {'isthing': 1, 'id': 373, 'name': 'dish'} ,
    {'isthing': 1, 'id': 382, 'name': 'dog'} ,
    {'isthing': 1, 'id': 391, 'name': 'doormat'} ,
    {'isthing': 1, 'id': 395, 'name': 'drawer'} ,
    {'isthing': 1, 'id': 398, 'name': 'dress_hat'} ,
    {'isthing': 1, 'id': 403, 'name': 'drone'} ,
    {'isthing': 1, 'id': 405, 'name': 'drum_(musical_instrument)'} ,
    {'isthing': 1, 'id': 406, 'name': 'drumstick'} ,
    {'isthing': 1, 'id': 407, 'name': 'duck'} ,
    {'isthing': 1, 'id': 410, 'name': 'duffel_bag'} ,
    {'isthing': 1, 'id': 413, 'name': 'dustpan'} ,
    {'isthing': 1, 'id': 415, 'name': 'eagle'} ,
    {'isthing': 1, 'id': 416, 'name': 'earphone'} ,
    {'isthing': 1, 'id': 425, 'name': 'eggbeater'} ,
    {'isthing': 1, 'id': 428, 'name': 'refrigerator'} ,
    {'isthing': 1, 'id': 429, 'name': 'elephant'} ,
    {'isthing': 1, 'id': 431, 'name': 'envelope'} ,
    {'isthing': 1, 'id': 437, 'name': 'faucet'} ,
    {'isthing': 1, 'id': 453, 'name': 'fish'} ,
    {'isthing': 1, 'id': 457, 'name': 'fishing_rod'} ,
    {'isthing': 1, 'id': 458, 'name': 'flag'} ,
    {'isthing': 1, 'id': 468, 'name': 'flute_glass'} ,
    {'isthing': 1, 'id': 473, 'name': 'football_helmet'} ,
    {'isthing': 1, 'id': 475, 'name': 'fork'} ,
    {'isthing': 1, 'id': 480, 'name': 'frisbee'} ,
    {'isthing': 1, 'id': 481, 'name': 'frog'} ,
    {'isthing': 1, 'id': 489, 'name': 'garbage'} ,
    {'isthing': 1, 'id': 490, 'name': 'garbage_truck'} ,
    {'isthing': 1, 'id': 499, 'name': 'giant_panda'} ,
    {'isthing': 1, 'id': 500, 'name': 'gift_wrap'} ,
    {'isthing': 1, 'id': 502, 'name': 'giraffe'} ,
    {'isthing': 1, 'id': 507, 'name': 'goat'} ,
    {'isthing': 1, 'id': 513, 'name': 'goose'} ,
    {'isthing': 1, 'id': 514, 'name': 'gorilla'} ,
    {'isthing': 1, 'id': 529, 'name': 'grocery_bag'} ,
    {'isthing': 1, 'id': 531, 'name': 'guitar'} ,
    {'isthing': 1, 'id': 533, 'name': 'gun'} ,
    {'isthing': 1, 'id': 535, 'name': 'hairbrush'} ,
    {'isthing': 1, 'id': 540, 'name': 'hammer'} ,
    {'isthing': 1, 'id': 544, 'name': 'hair_dryer'} ,
    {'isthing': 1, 'id': 548, 'name': 'handcuff'} ,
    {'isthing': 1, 'id': 553, 'name': 'harmonium'} ,
    {'isthing': 1, 'id': 554, 'name': 'hat'} ,
    {'isthing': 1, 'id': 567, 'name': 'helicopter'} ,
    {'isthing': 1, 'id': 568, 'name': 'helmet'} ,
    {'isthing': 1, 'id': 569, 'name': 'heron'} ,
    {'isthing': 1, 'id': 572, 'name': 'hippopotamus'} ,
    {'isthing': 1, 'id': 573, 'name': 'hockey_stick'} ,
    {'isthing': 1, 'id': 574, 'name': 'hog'} ,
    {'isthing': 1, 'id': 579, 'name': 'horse'} ,
    {'isthing': 1, 'id': 580, 'name': 'hose'} ,
    {'isthing': 1, 'id': 588, 'name': 'polar_bear'} ,
    {'isthing': 1, 'id': 589, 'name': 'icecream'} ,
    {'isthing': 1, 'id': 595, 'name': 'igniter'} ,
    {'isthing': 1, 'id': 599, 'name': 'iron_(for_clothing)'} ,
    {'isthing': 1, 'id': 601, 'name': 'jacket'} ,
    {'isthing': 1, 'id': 603, 'name': 'jean'} ,
    {'isthing': 1, 'id': 606, 'name': 'jersey'} ,
    {'isthing': 1, 'id': 611, 'name': 'kayak'} ,
    {'isthing': 1, 'id': 614, 'name': 'kettle'} ,
    {'isthing': 1, 'id': 621, 'name': 'kite'} ,
    {'isthing': 1, 'id': 625, 'name': 'knife'} ,
    {'isthing': 1, 'id': 627, 'name': 'knitting_needle'} ,
    {'isthing': 1, 'id': 628, 'name': 'knob'} ,
    {'isthing': 1, 'id': 633, 'name': 'ladle'} ,
    {'isthing': 1, 'id': 637, 'name': 'lamp'} ,
    {'isthing': 1, 'id': 641, 'name': 'lanyard'} ,
    {'isthing': 1, 'id': 642, 'name': 'laptop_computer'} ,
    {'isthing': 1, 'id': 645, 'name': 'lawn_mower'} ,
    {'isthing': 1, 'id': 649, 'name': 'lemon'} ,
    {'isthing': 1, 'id': 653, 'name': 'life_buoy'} ,
    {'isthing': 1, 'id': 660, 'name': 'lion'} ,
    {'isthing': 1, 'id': 664, 'name': 'lizard'} ,
    {'isthing': 1, 'id': 666, 'name': 'log'} ,
    {'isthing': 1, 'id': 672, 'name': 'magazine'} ,
    {'isthing': 1, 'id': 676, 'name': 'mallet'} ,
    {'isthing': 1, 'id': 682, 'name': 'marker'} ,
    {'isthing': 1, 'id': 690, 'name': 'matchbox'} ,
    {'isthing': 1, 'id': 691, 'name': 'mattress'} ,
    {'isthing': 1, 'id': 692, 'name': 'measuring_cup'} ,
    {'isthing': 1, 'id': 695, 'name': 'medicine'} ,
    {'isthing': 1, 'id': 697, 'name': 'microphone'} ,
    {'isthing': 1, 'id': 702, 'name': 'minivan'} ,
    {'isthing': 1, 'id': 704, 'name': 'mirror'} ,
    {'isthing': 1, 'id': 706, 'name': 'mixer_(kitchen_tool)'} ,
    {'isthing': 1, 'id': 707, 'name': 'money'} ,
    {'isthing': 1, 'id': 708, 'name': 'monitor_(computer_equipment) computer_monitor'} ,
    {'isthing': 1, 'id': 709, 'name': 'monkey'} ,
    {'isthing': 1, 'id': 711, 'name': 'motor_scooter'} ,
    {'isthing': 1, 'id': 713, 'name': 'motorboat'} ,
    {'isthing': 1, 'id': 714, 'name': 'motorcycle'} ,
    {'isthing': 1, 'id': 717, 'name': 'mouse_(computer_equipment)'} ,
    {'isthing': 1, 'id': 723, 'name': 'musical_instrument'} ,
    {'isthing': 1, 'id': 726, 'name': 'napkin'} ,
    {'isthing': 1, 'id': 728, 'name': 'necklace'} ,
    {'isthing': 1, 'id': 736, 'name': 'notebook'} ,
    {'isthing': 1, 'id': 737, 'name': 'notepad'} ,
    {'isthing': 1, 'id': 738, 'name': 'nut'} ,
    {'isthing': 1, 'id': 740, 'name': 'oar'} ,
    {'isthing': 1, 'id': 747, 'name': 'orange_(fruit)'} ,
    {'isthing': 1, 'id': 754, 'name': 'packet'} ,
    {'isthing': 1, 'id': 757, 'name': 'paddle'} ,
    {'isthing': 1, 'id': 760, 'name': 'paintbrush'} ,
    {'isthing': 1, 'id': 764, 'name': 'pan_(for_cooking)'} ,
    {'isthing': 1, 'id': 771, 'name': 'paper_towel'} ,
    {'isthing': 1, 'id': 774, 'name': 'parachute'} ,
    {'isthing': 1, 'id': 790, 'name': 'peeler_(tool_for_fruit_and_vegetables)'} ,
    {'isthing': 1, 'id': 793, 'name': 'pen'} ,
    {'isthing': 1, 'id': 794, 'name': 'pencil'} ,
    {'isthing': 1, 'id': 798, 'name': 'penguin'} ,
    {'isthing': 1, 'id': 805, 'name': 'baby'} ,
    {'isthing': 1, 'id': 811, 'name': 'piano'} ,
    {'isthing': 1, 'id': 813, 'name': 'pickup_truck'} ,
    {'isthing': 1, 'id': 815, 'name': 'pigeon'} ,
    {'isthing': 1, 'id': 817, 'name': 'pillow'} ,
    {'isthing': 1, 'id': 825, 'name': 'pistol'} ,
    {'isthing': 1, 'id': 827, 'name': 'pitcher_(vessel_for_liquid)'} ,
    {'isthing': 1, 'id': 829, 'name': 'pizza'} ,
    {'isthing': 1, 'id': 831, 'name': 'plate'} ,
    {'isthing': 1, 'id': 835, 'name': 'pliers'} ,
    {'isthing': 1, 'id': 840, 'name': 'pole'} ,
    {'isthing': 1, 'id': 851, 'name': 'pot'} ,
    {'isthing': 1, 'id': 853, 'name': 'potato'} ,
    {'isthing': 1, 'id': 875, 'name': 'rabbit'} ,
    {'isthing': 1, 'id': 877, 'name': 'racket'} ,
    {'isthing': 1, 'id': 883, 'name': 'rag_doll'} ,
    {'isthing': 1, 'id': 887, 'name': 'rat'} ,
    {'isthing': 1, 'id': 893, 'name': 'record_player'} ,
    {'isthing': 1, 'id': 896, 'name': 'remote_control'} ,
    {'isthing': 1, 'id': 899, 'name': 'rifle'} ,
    {'isthing': 1, 'id': 925, 'name': 'sandal_(type_of_shoe)'} ,
    {'isthing': 1, 'id': 926, 'name': 'sandwich'} ,
    {'isthing': 1, 'id': 932, 'name': 'saxophone'} ,
    {'isthing': 1, 'id': 937, 'name': 'scissors'} ,
    {'isthing': 1, 'id': 940, 'name': 'scraper'} ,
    {'isthing': 1, 'id': 943, 'name': 'scrubbing_brush'} ,
    {'isthing': 1, 'id': 944, 'name': 'sculpture'} ,
    {'isthing': 1, 'id': 952, 'name': 'shaker'} ,
    {'isthing': 1, 'id': 954, 'name': 'shark'} ,
    {'isthing': 1, 'id': 959, 'name': 'shawl'} ,
    {'isthing': 1, 'id': 961, 'name': 'sheep'} ,
    {'isthing': 1, 'id': 965, 'name': 'shirt'} ,
    {'isthing': 1, 'id': 966, 'name': 'shoe'} ,
    {'isthing': 1, 'id': 971, 'name': 'shoulder_bag'} ,
    {'isthing': 1, 'id': 980, 'name': 'skateboard'} ,
    {'isthing': 1, 'id': 985, 'name': 'ski_pole'} ,
    {'isthing': 1, 'id': 986, 'name': 'skirt'} ,
    {'isthing': 1, 'id': 990, 'name': 'slipper_(footwear)'} ,
    {'isthing': 1, 'id': 1012, 'name': 'spatula'} ,
    {'isthing': 1, 'id': 1014, 'name': 'spectacles'} ,
    {'isthing': 1, 'id': 1016, 'name': 'spider'} ,
    {'isthing': 1, 'id': 1017, 'name': 'sponge'} ,
    {'isthing': 1, 'id': 1018, 'name': 'spoon'} ,
    {'isthing': 1, 'id': 1021, 'name': 'squirrel'} ,
    {'isthing': 1, 'id': 1024, 'name': 'statue_(sculpture)'} ,
    {'isthing': 1, 'id': 1028, 'name': 'steering_wheel'} ,
    {'isthing': 1, 'id': 1031, 'name': 'step_stool'} ,
    {'isthing': 1, 'id': 1037, 'name': 'stool'} ,
    {'isthing': 1, 'id': 1043, 'name': 'straw_(for_drinking)'} ,
    {'isthing': 1, 'id': 1050, 'name': 'sugar_bowl'} ,
    {'isthing': 1, 'id': 1054, 'name': 'sunglasses'} ,
    {'isthing': 1, 'id': 1057, 'name': 'surfboard'} ,
    {'isthing': 1, 'id': 1059, 'name': 'mop'} ,
    {'isthing': 1, 'id': 1062, 'name': 'sweater'} ,
    {'isthing': 1, 'id': 1066, 'name': 'sword'} ,
    {'isthing': 1, 'id': 1078, 'name': 'army_tank'} ,
    {'isthing': 1, 'id': 1081, 'name': 'tape_(sticky_cloth_or_paper)'} ,
    {'isthing': 1, 'id': 1084, 'name': 'tarp'} ,
    {'isthing': 1, 'id': 1088, 'name': 'teacup'} ,
    {'isthing': 1, 'id': 1089, 'name': 'teakettle'} ,
    {'isthing': 1, 'id': 1090, 'name': 'teapot'} ,
    {'isthing': 1, 'id': 1092, 'name': 'telephone'} ,
    {'isthing': 1, 'id': 1099, 'name': 'tennis_racket'} ,
    {'isthing': 1, 'id': 1101, 'name': 'thermometer'} ,
    {'isthing': 1, 'id': 1105, 'name': 'thread'} ,
    {'isthing': 1, 'id': 1113, 'name': 'tissue_paper'} ,
    {'isthing': 1, 'id': 1114, 'name': 'toast_(food)'} ,
    {'isthing': 1, 'id': 1121, 'name': 'toolbox'} ,
    {'isthing': 1, 'id': 1122, 'name': 'toothbrush'} ,
    {'isthing': 1, 'id': 1123, 'name': 'toothpaste'} ,
    {'isthing': 1, 'id': 1125, 'name': 'cover'} ,
    {'isthing': 1, 'id': 1128, 'name': 'towel'} ,
    {'isthing': 1, 'id': 1130, 'name': 'toy'} ,
    {'isthing': 1, 'id': 1133, 'name': 'dirt_bike'} ,
    {'isthing': 1, 'id': 1134, 'name': 'trailer_truck'} ,
    {'isthing': 1, 'id': 1137, 'name': 'tray'} ,
    {'isthing': 1, 'id': 1142, 'name': 'tripod'} ,
    {'isthing': 1, 'id': 1143, 'name': 'trousers'} ,
    {'isthing': 1, 'id': 1144, 'name': 'truck'} ,
    {'isthing': 1, 'id': 1152, 'name': 'turtle'} ,
    {'isthing': 1, 'id': 1155, 'name': 'umbrella'} ,
    {'isthing': 1, 'id': 1156, 'name': 'underwear'} ,
    {'isthing': 1, 'id': 1160, 'name': 'vacuum_cleaner'} ,
    {'isthing': 1, 'id': 1169, 'name': 'volleyball'} ,
    {'isthing': 1, 'id': 1175, 'name': 'walking_stick'} ,
    {'isthing': 1, 'id': 1178, 'name': 'wallet'} ,
    {'isthing': 1, 'id': 1179, 'name': 'walrus'} ,
    {'isthing': 1, 'id': 1182, 'name': 'automatic_washer'} ,
    {'isthing': 1, 'id': 1184, 'name': 'water_bottle'} ,
    {'isthing': 1, 'id': 1189, 'name': 'water_jug'} ,
    {'isthing': 1, 'id': 1191, 'name': 'water_scooter'} ,
    {'isthing': 1, 'id': 1192, 'name': 'water_ski'} ,
    {'isthing': 1, 'id': 1211, 'name': 'windshield_wiper'} ,
    {'isthing': 1, 'id': 1215, 'name': 'wineglass'} ,
    {'isthing': 1, 'id': 1220, 'name': 'wooden_spoon'} ,
    {'isthing': 1, 'id': 1229, 'name': 'zebra'} ,
    ]

TAO_CATEGORIES_full = [
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1, 'name': 'acorn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 2, 'name': 'aerosol_can'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 3, 'name': 'air_conditioner'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 4, 'name': 'airplane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 5, 'name': 'alarm_clock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 6, 'name': 'alcohol'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 7, 'name': 'alligator'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 8, 'name': 'almond'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 9, 'name': 'ambulance'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 10, 'name': 'amplifier'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 11, 'name': 'anklet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 12, 'name': 'antenna'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 13, 'name': 'apple'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 14, 'name': 'apple_juice'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 15, 'name': 'applesauce'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 16, 'name': 'apricot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 17, 'name': 'apron'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 18, 'name': 'aquarium'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 19, 'name': 'armband'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 20, 'name': 'armchair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 21, 'name': 'armoire'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 22, 'name': 'armor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 23, 'name': 'artichoke'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 24, 'name': 'trash_can'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 25, 'name': 'ashtray'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 26, 'name': 'asparagus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 27, 'name': 'atomizer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 28, 'name': 'avocado'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 29, 'name': 'award'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 30, 'name': 'awning'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 31, 'name': 'ax'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 32, 'name': 'baby_buggy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 33, 'name': 'basketball_backboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 34, 'name': 'backpack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 35, 'name': 'handbag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 36, 'name': 'suitcase'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 37, 'name': 'bagel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 38, 'name': 'bagpipe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 39, 'name': 'baguet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 40, 'name': 'bait'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 41, 'name': 'ball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 42, 'name': 'ballet_skirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 43, 'name': 'balloon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 44, 'name': 'bamboo'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 45, 'name': 'banana'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 46, 'name': 'Band_Aid'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 47, 'name': 'bandage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 48, 'name': 'bandanna'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 49, 'name': 'banjo'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 50, 'name': 'banner'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 51, 'name': 'barbell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 52, 'name': 'barge'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 53, 'name': 'barrel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 54, 'name': 'barrette'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 55, 'name': 'barrow'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 56, 'name': 'baseball_base'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 57, 'name': 'baseball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 58, 'name': 'baseball_bat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 59, 'name': 'baseball_cap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 60, 'name': 'baseball_glove'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 61, 'name': 'basket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 62, 'name': 'basketball_hoop'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 63, 'name': 'basketball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 64, 'name': 'bass_horn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 65, 'name': 'bat_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 66, 'name': 'bath_mat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 67, 'name': 'bath_towel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 68, 'name': 'bathrobe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 69, 'name': 'bathtub'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 70, 'name': 'batter_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 71, 'name': 'battery'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 72, 'name': 'beachball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 73, 'name': 'bead'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 74, 'name': 'beaker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 75, 'name': 'bean_curd'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 76, 'name': 'beanbag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 77, 'name': 'beanie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 78, 'name': 'bear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 79, 'name': 'bed'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 80, 'name': 'bedspread'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 81, 'name': 'cow'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 82, 'name': 'beef_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 83, 'name': 'beeper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 84, 'name': 'beer_bottle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 85, 'name': 'beer_can'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 86, 'name': 'beetle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 87, 'name': 'bell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 88, 'name': 'bell_pepper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 89, 'name': 'belt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 90, 'name': 'belt_buckle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 91, 'name': 'bench'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 92, 'name': 'beret'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 93, 'name': 'bib'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 94, 'name': 'Bible'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 95, 'name': 'bicycle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 96, 'name': 'visor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 97, 'name': 'binder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 98, 'name': 'binoculars'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 99, 'name': 'bird'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 100, 'name': 'birdfeeder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 101, 'name': 'birdbath'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 102, 'name': 'birdcage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 103, 'name': 'birdhouse'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 104, 'name': 'birthday_cake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 105, 'name': 'birthday_card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 106, 'name': 'biscuit_(bread)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 107, 'name': 'pirate_flag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 108, 'name': 'black_sheep'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 109, 'name': 'blackboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 110, 'name': 'blanket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 111, 'name': 'blazer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 112, 'name': 'blender'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 113, 'name': 'blimp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 114, 'name': 'blinker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 115, 'name': 'blueberry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 116, 'name': 'boar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 117, 'name': 'gameboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 118, 'name': 'boat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 119, 'name': 'bobbin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 120, 'name': 'bobby_pin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 121, 'name': 'boiled_egg'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 122, 'name': 'bolo_tie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 123, 'name': 'deadbolt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 124, 'name': 'bolt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 125, 'name': 'bonnet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 126, 'name': 'book'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 127, 'name': 'book_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 128, 'name': 'bookcase'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 129, 'name': 'booklet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 130, 'name': 'bookmark'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 131, 'name': 'boom_microphone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 132, 'name': 'boot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 133, 'name': 'bottle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 134, 'name': 'bottle_opener'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 135, 'name': 'bouquet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 136, 'name': 'bow_(weapon)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 137, 'name': 'bow_(decorative_ribbons)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 138, 'name': 'bow-tie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 139, 'name': 'bowl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 140, 'name': 'pipe_bowl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 141, 'name': 'bowler_hat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 142, 'name': 'bowling_ball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 143, 'name': 'bowling_pin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 144, 'name': 'boxing_glove'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 145, 'name': 'suspenders'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 146, 'name': 'bracelet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 147, 'name': 'brass_plaque'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 148, 'name': 'brassiere'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 149, 'name': 'bread-bin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 150, 'name': 'breechcloth'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 151, 'name': 'bridal_gown'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 152, 'name': 'briefcase'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 153, 'name': 'bristle_brush'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 154, 'name': 'broccoli'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 155, 'name': 'broach'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 156, 'name': 'broom'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 157, 'name': 'brownie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 158, 'name': 'brussels_sprouts'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 159, 'name': 'bubble_gum'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 160, 'name': 'bucket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 161, 'name': 'horse_buggy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 162, 'name': 'bull'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 163, 'name': 'bulldog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 164, 'name': 'bulldozer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 165, 'name': 'bullet_train'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 166, 'name': 'bulletin_board'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 167, 'name': 'bulletproof_vest'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 168, 'name': 'bullhorn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 169, 'name': 'corned_beef'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 170, 'name': 'bun'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 171, 'name': 'bunk_bed'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 172, 'name': 'buoy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 173, 'name': 'burrito'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 174, 'name': 'bus_(vehicle)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 175, 'name': 'business_card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 176, 'name': 'butcher_knife'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 177, 'name': 'butter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 178, 'name': 'butterfly'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 179, 'name': 'button'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 180, 'name': 'cab_(taxi)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 181, 'name': 'cabana'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 182, 'name': 'cabin_car'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 183, 'name': 'cabinet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 184, 'name': 'locker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 185, 'name': 'cake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 186, 'name': 'calculator'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 187, 'name': 'calendar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 188, 'name': 'calf'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 189, 'name': 'camcorder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 190, 'name': 'camel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 191, 'name': 'camera'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 192, 'name': 'camera_lens'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 193, 'name': 'camper_(vehicle)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 194, 'name': 'can'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 195, 'name': 'can_opener'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 196, 'name': 'candelabrum'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 197, 'name': 'candle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 198, 'name': 'candle_holder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 199, 'name': 'candy_bar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 200, 'name': 'candy_cane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 201, 'name': 'walking_cane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 202, 'name': 'canister'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 203, 'name': 'cannon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 204, 'name': 'canoe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 205, 'name': 'cantaloup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 206, 'name': 'canteen'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 207, 'name': 'cap_(headwear)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 208, 'name': 'bottle_cap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 209, 'name': 'cape'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 210, 'name': 'cappuccino'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 211, 'name': 'car_(automobile)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 212, 'name': 'railcar_(part_of_a_train)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 213, 'name': 'elevator_car'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 214, 'name': 'car_battery'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 215, 'name': 'identity_card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 216, 'name': 'card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 217, 'name': 'cardigan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 218, 'name': 'cargo_ship'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 219, 'name': 'carnation'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 220, 'name': 'horse_carriage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 221, 'name': 'carrot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 222, 'name': 'tote_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 223, 'name': 'cart'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 224, 'name': 'carton'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 225, 'name': 'cash_register'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 226, 'name': 'casserole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 227, 'name': 'cassette'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 228, 'name': 'cast'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 229, 'name': 'cat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 230, 'name': 'cauliflower'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 231, 'name': 'caviar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 232, 'name': 'cayenne_(spice)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 233, 'name': 'CD_player'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 234, 'name': 'celery'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 235, 'name': 'cellular_telephone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 236, 'name': 'chain_mail'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 237, 'name': 'chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 238, 'name': 'chaise_longue'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 239, 'name': 'champagne'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 240, 'name': 'chandelier'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 241, 'name': 'chap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 242, 'name': 'checkbook'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 243, 'name': 'checkerboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 244, 'name': 'cherry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 245, 'name': 'chessboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 246, 'name': 'chest_of_drawers_(furniture)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 247, 'name': 'chicken_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 248, 'name': 'chicken_wire'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 249, 'name': 'chickpea'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 250, 'name': 'Chihuahua'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 251, 'name': 'chili_(vegetable)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 252, 'name': 'chime'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 253, 'name': 'chinaware'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 254, 'name': 'crisp_(potato_chip)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 255, 'name': 'poker_chip'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 256, 'name': 'chocolate_bar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 257, 'name': 'chocolate_cake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 258, 'name': 'chocolate_milk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 259, 'name': 'chocolate_mousse'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 260, 'name': 'choker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 261, 'name': 'chopping_board'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 262, 'name': 'chopstick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 263, 'name': 'Christmas_tree'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 264, 'name': 'slide'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 265, 'name': 'cider'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 266, 'name': 'cigar_box'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 267, 'name': 'cigarette'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 268, 'name': 'cigarette_case'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 269, 'name': 'cistern'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 270, 'name': 'clarinet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 271, 'name': 'clasp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 272, 'name': 'cleansing_agent'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 273, 'name': 'clementine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 274, 'name': 'clip'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 275, 'name': 'clipboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 276, 'name': 'clock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 277, 'name': 'clock_tower'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 278, 'name': 'clothes_hamper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 279, 'name': 'clothespin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 280, 'name': 'clutch_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 281, 'name': 'coaster'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 282, 'name': 'coat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 283, 'name': 'coat_hanger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 284, 'name': 'coatrack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 285, 'name': 'cock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 286, 'name': 'coconut'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 287, 'name': 'coffee_filter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 288, 'name': 'coffee_maker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 289, 'name': 'coffee_table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 290, 'name': 'coffeepot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 291, 'name': 'coil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 292, 'name': 'coin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 293, 'name': 'colander'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 294, 'name': 'coleslaw'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 295, 'name': 'coloring_material'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 296, 'name': 'combination_lock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 297, 'name': 'pacifier'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 298, 'name': 'comic_book'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 299, 'name': 'computer_keyboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 300, 'name': 'concrete_mixer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 301, 'name': 'cone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 302, 'name': 'control'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 303, 'name': 'convertible_(automobile)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 304, 'name': 'sofa_bed'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 305, 'name': 'cookie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 306, 'name': 'cookie_jar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 307, 'name': 'cooking_utensil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 308, 'name': 'cooler_(for_food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 309, 'name': 'cork_(bottle_plug)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 310, 'name': 'corkboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 311, 'name': 'corkscrew'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 312, 'name': 'edible_corn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 313, 'name': 'cornbread'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 314, 'name': 'cornet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 315, 'name': 'cornice'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 316, 'name': 'cornmeal'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 317, 'name': 'corset'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 318, 'name': 'romaine_lettuce'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 319, 'name': 'costume'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 320, 'name': 'cougar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 321, 'name': 'coverall'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 322, 'name': 'cowbell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 323, 'name': 'cowboy_hat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 324, 'name': 'crab_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 325, 'name': 'cracker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 326, 'name': 'crape'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 327, 'name': 'crate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 328, 'name': 'crayon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 329, 'name': 'cream_pitcher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 330, 'name': 'credit_card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 331, 'name': 'crescent_roll'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 332, 'name': 'crib'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 333, 'name': 'crock_pot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 334, 'name': 'crossbar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 335, 'name': 'crouton'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 336, 'name': 'crow'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 337, 'name': 'crown'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 338, 'name': 'crucifix'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 339, 'name': 'cruise_ship'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 340, 'name': 'police_cruiser'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 341, 'name': 'crumb'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 342, 'name': 'crutch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 343, 'name': 'cub_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 344, 'name': 'cube'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 345, 'name': 'cucumber'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 346, 'name': 'cufflink'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 347, 'name': 'cup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 348, 'name': 'trophy_cup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 349, 'name': 'cupcake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 350, 'name': 'hair_curler'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 351, 'name': 'curling_iron'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 352, 'name': 'curtain'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 353, 'name': 'cushion'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 354, 'name': 'custard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 355, 'name': 'cutting_tool'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 356, 'name': 'cylinder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 357, 'name': 'cymbal'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 358, 'name': 'dachshund'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 359, 'name': 'dagger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 360, 'name': 'dartboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 361, 'name': 'date_(fruit)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 362, 'name': 'deck_chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 363, 'name': 'deer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 364, 'name': 'dental_floss'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 365, 'name': 'desk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 366, 'name': 'detergent'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 367, 'name': 'diaper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 368, 'name': 'diary'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 369, 'name': 'die'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 370, 'name': 'dinghy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 371, 'name': 'dining_table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 372, 'name': 'tux'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 373, 'name': 'dish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 374, 'name': 'dish_antenna'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 375, 'name': 'dishrag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 376, 'name': 'dishtowel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 377, 'name': 'dishwasher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 378, 'name': 'dishwasher_detergent'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 379, 'name': 'diskette'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 380, 'name': 'dispenser'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 381, 'name': 'Dixie_cup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 382, 'name': 'dog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 383, 'name': 'dog_collar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 384, 'name': 'doll'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 385, 'name': 'dollar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 386, 'name': 'dolphin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 387, 'name': 'domestic_ass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 388, 'name': 'eye_mask'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 389, 'name': 'doorbell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 390, 'name': 'doorknob'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 391, 'name': 'doormat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 392, 'name': 'doughnut'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 393, 'name': 'dove'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 394, 'name': 'dragonfly'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 395, 'name': 'drawer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 396, 'name': 'underdrawers'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 397, 'name': 'dress'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 398, 'name': 'dress_hat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 399, 'name': 'dress_suit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 400, 'name': 'dresser'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 401, 'name': 'drill'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 402, 'name': 'drinking_fountain'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 403, 'name': 'drone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 404, 'name': 'dropper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 405, 'name': 'drum_(musical_instrument)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 406, 'name': 'drumstick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 407, 'name': 'duck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 408, 'name': 'duckling'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 409, 'name': 'duct_tape'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 410, 'name': 'duffel_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 411, 'name': 'dumbbell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 412, 'name': 'dumpster'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 413, 'name': 'dustpan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 414, 'name': 'Dutch_oven'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 415, 'name': 'eagle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 416, 'name': 'earphone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 417, 'name': 'earplug'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 418, 'name': 'earring'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 419, 'name': 'easel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 420, 'name': 'eclair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 421, 'name': 'eel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 422, 'name': 'egg'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 423, 'name': 'egg_roll'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 424, 'name': 'egg_yolk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 425, 'name': 'eggbeater'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 426, 'name': 'eggplant'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 427, 'name': 'electric_chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 428, 'name': 'refrigerator'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 429, 'name': 'elephant'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 430, 'name': 'elk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 431, 'name': 'envelope'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 432, 'name': 'eraser'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 433, 'name': 'escargot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 434, 'name': 'eyepatch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 435, 'name': 'falcon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 436, 'name': 'fan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 437, 'name': 'faucet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 438, 'name': 'fedora'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 439, 'name': 'ferret'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 440, 'name': 'Ferris_wheel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 441, 'name': 'ferry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 442, 'name': 'fig_(fruit)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 443, 'name': 'fighter_jet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 444, 'name': 'figurine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 445, 'name': 'file_cabinet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 446, 'name': 'file_(tool)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 447, 'name': 'fire_alarm'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 448, 'name': 'fire_engine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 449, 'name': 'fire_extinguisher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 450, 'name': 'fire_hose'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 451, 'name': 'fireplace'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 452, 'name': 'fireplug'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 453, 'name': 'fish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 454, 'name': 'fish_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 455, 'name': 'fishbowl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 456, 'name': 'fishing_boat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 457, 'name': 'fishing_rod'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 458, 'name': 'flag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 459, 'name': 'flagpole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 460, 'name': 'flamingo'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 461, 'name': 'flannel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 462, 'name': 'flash'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 463, 'name': 'flashlight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 464, 'name': 'fleece'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 465, 'name': 'flip-flop_(sandal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 466, 'name': 'flipper_(footwear)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 467, 'name': 'flower_arrangement'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 468, 'name': 'flute_glass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 469, 'name': 'foal'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 470, 'name': 'folding_chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 471, 'name': 'food_processor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 472, 'name': 'football_(American)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 473, 'name': 'football_helmet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 474, 'name': 'footstool'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 475, 'name': 'fork'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 476, 'name': 'forklift'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 477, 'name': 'freight_car'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 478, 'name': 'French_toast'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 479, 'name': 'freshener'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 480, 'name': 'frisbee'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 481, 'name': 'frog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 482, 'name': 'fruit_juice'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 483, 'name': 'fruit_salad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 484, 'name': 'frying_pan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 485, 'name': 'fudge'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 486, 'name': 'funnel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 487, 'name': 'futon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 488, 'name': 'gag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 489, 'name': 'garbage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 490, 'name': 'garbage_truck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 491, 'name': 'garden_hose'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 492, 'name': 'gargle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 493, 'name': 'gargoyle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 494, 'name': 'garlic'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 495, 'name': 'gasmask'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 496, 'name': 'gazelle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 497, 'name': 'gelatin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 498, 'name': 'gemstone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 499, 'name': 'giant_panda'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 500, 'name': 'gift_wrap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 501, 'name': 'ginger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 502, 'name': 'giraffe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 503, 'name': 'cincture'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 504, 'name': 'glass_(drink_container)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 505, 'name': 'globe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 506, 'name': 'glove'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 507, 'name': 'goat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 508, 'name': 'goggles'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 509, 'name': 'goldfish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 510, 'name': 'golf_club'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 511, 'name': 'golfcart'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 512, 'name': 'gondola_(boat)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 513, 'name': 'goose'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 514, 'name': 'gorilla'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 515, 'name': 'gourd'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 516, 'name': 'surgical_gown'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 517, 'name': 'grape'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 518, 'name': 'grasshopper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 519, 'name': 'grater'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 520, 'name': 'gravestone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 521, 'name': 'gravy_boat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 522, 'name': 'green_bean'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 523, 'name': 'green_onion'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 524, 'name': 'griddle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 525, 'name': 'grillroom'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 526, 'name': 'grinder_(tool)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 527, 'name': 'grits'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 528, 'name': 'grizzly'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 529, 'name': 'grocery_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 530, 'name': 'guacamole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 531, 'name': 'guitar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 532, 'name': 'gull'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 533, 'name': 'gun'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 534, 'name': 'hair_spray'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 535, 'name': 'hairbrush'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 536, 'name': 'hairnet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 537, 'name': 'hairpin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 538, 'name': 'ham'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 539, 'name': 'hamburger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 540, 'name': 'hammer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 541, 'name': 'hammock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 542, 'name': 'hamper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 543, 'name': 'hamster'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 544, 'name': 'hair_dryer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 545, 'name': 'hand_glass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 546, 'name': 'hand_towel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 547, 'name': 'handcart'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 548, 'name': 'handcuff'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 549, 'name': 'handkerchief'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 550, 'name': 'handle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 551, 'name': 'handsaw'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 552, 'name': 'hardback_book'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 553, 'name': 'harmonium'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 554, 'name': 'hat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 555, 'name': 'hatbox'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 556, 'name': 'hatch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 557, 'name': 'veil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 558, 'name': 'headband'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 559, 'name': 'headboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 560, 'name': 'headlight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 561, 'name': 'headscarf'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 562, 'name': 'headset'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 563, 'name': 'headstall_(for_horses)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 564, 'name': 'hearing_aid'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 565, 'name': 'heart'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 566, 'name': 'heater'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 567, 'name': 'helicopter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 568, 'name': 'helmet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 569, 'name': 'heron'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 570, 'name': 'highchair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 571, 'name': 'hinge'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 572, 'name': 'hippopotamus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 573, 'name': 'hockey_stick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 574, 'name': 'hog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 575, 'name': 'home_plate_(baseball)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 576, 'name': 'honey'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 577, 'name': 'fume_hood'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 578, 'name': 'hook'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 579, 'name': 'horse'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 580, 'name': 'hose'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 581, 'name': 'hot-air_balloon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 582, 'name': 'hotplate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 583, 'name': 'hot_sauce'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 584, 'name': 'hourglass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 585, 'name': 'houseboat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 586, 'name': 'hummingbird'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 587, 'name': 'hummus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 588, 'name': 'polar_bear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 589, 'name': 'icecream'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 590, 'name': 'popsicle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 591, 'name': 'ice_maker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 592, 'name': 'ice_pack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 593, 'name': 'ice_skate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 594, 'name': 'ice_tea'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 595, 'name': 'igniter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 596, 'name': 'incense'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 597, 'name': 'inhaler'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 598, 'name': 'iPod'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 599, 'name': 'iron_(for_clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 600, 'name': 'ironing_board'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 601, 'name': 'jacket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 602, 'name': 'jam'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 603, 'name': 'jean'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 604, 'name': 'jeep'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 605, 'name': 'jelly_bean'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 606, 'name': 'jersey'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 607, 'name': 'jet_plane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 608, 'name': 'jewelry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 609, 'name': 'joystick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 610, 'name': 'jumpsuit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 611, 'name': 'kayak'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 612, 'name': 'keg'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 613, 'name': 'kennel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 614, 'name': 'kettle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 615, 'name': 'key'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 616, 'name': 'keycard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 617, 'name': 'kilt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 618, 'name': 'kimono'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 619, 'name': 'kitchen_sink'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 620, 'name': 'kitchen_table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 621, 'name': 'kite'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 622, 'name': 'kitten'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 623, 'name': 'kiwi_fruit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 624, 'name': 'knee_pad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 625, 'name': 'knife'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 626, 'name': 'knight_(chess_piece)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 627, 'name': 'knitting_needle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 628, 'name': 'knob'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 629, 'name': 'knocker_(on_a_door)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 630, 'name': 'koala'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 631, 'name': 'lab_coat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 632, 'name': 'ladder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 633, 'name': 'ladle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 634, 'name': 'ladybug'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 635, 'name': 'lamb_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 636, 'name': 'lamb-chop'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 637, 'name': 'lamp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 638, 'name': 'lamppost'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 639, 'name': 'lampshade'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 640, 'name': 'lantern'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 641, 'name': 'lanyard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 642, 'name': 'laptop_computer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 643, 'name': 'lasagna'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 644, 'name': 'latch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 645, 'name': 'lawn_mower'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 646, 'name': 'leather'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 647, 'name': 'legging_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 648, 'name': 'Lego'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 649, 'name': 'lemon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 650, 'name': 'lemonade'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 651, 'name': 'lettuce'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 652, 'name': 'license_plate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 653, 'name': 'life_buoy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 654, 'name': 'life_jacket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 655, 'name': 'lightbulb'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 656, 'name': 'lightning_rod'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 657, 'name': 'lime'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 658, 'name': 'limousine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 659, 'name': 'linen_paper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 660, 'name': 'lion'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 661, 'name': 'lip_balm'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 662, 'name': 'lipstick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 663, 'name': 'liquor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 664, 'name': 'lizard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 665, 'name': 'Loafer_(type_of_shoe)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 666, 'name': 'log'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 667, 'name': 'lollipop'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 668, 'name': 'lotion'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 669, 'name': 'speaker_(stero_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 670, 'name': 'loveseat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 671, 'name': 'machine_gun'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 672, 'name': 'magazine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 673, 'name': 'magnet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 674, 'name': 'mail_slot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 675, 'name': 'mailbox_(at_home)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 676, 'name': 'mallet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 677, 'name': 'mammoth'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 678, 'name': 'mandarin_orange'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 679, 'name': 'manger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 680, 'name': 'manhole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 681, 'name': 'map'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 682, 'name': 'marker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 683, 'name': 'martini'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 684, 'name': 'mascot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 685, 'name': 'mashed_potato'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 686, 'name': 'masher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 687, 'name': 'mask'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 688, 'name': 'mast'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 689, 'name': 'mat_(gym_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 690, 'name': 'matchbox'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 691, 'name': 'mattress'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 692, 'name': 'measuring_cup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 693, 'name': 'measuring_stick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 694, 'name': 'meatball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 695, 'name': 'medicine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 696, 'name': 'melon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 697, 'name': 'microphone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 698, 'name': 'microscope'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 699, 'name': 'microwave_oven'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 700, 'name': 'milestone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 701, 'name': 'milk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 702, 'name': 'minivan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 703, 'name': 'mint_candy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 704, 'name': 'mirror'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 705, 'name': 'mitten'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 706, 'name': 'mixer_(kitchen_tool)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 707, 'name': 'money'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 708, 'name': 'monitor_(computer_equipment) computer_monitor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 709, 'name': 'monkey'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 710, 'name': 'motor'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 711, 'name': 'motor_scooter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 712, 'name': 'motor_vehicle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 713, 'name': 'motorboat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 714, 'name': 'motorcycle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 715, 'name': 'mound_(baseball)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 716, 'name': 'mouse_(animal_rodent)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 717, 'name': 'mouse_(computer_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 718, 'name': 'mousepad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 719, 'name': 'muffin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 720, 'name': 'mug'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 721, 'name': 'mushroom'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 722, 'name': 'music_stool'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 723, 'name': 'musical_instrument'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 724, 'name': 'nailfile'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 725, 'name': 'nameplate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 726, 'name': 'napkin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 727, 'name': 'neckerchief'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 728, 'name': 'necklace'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 729, 'name': 'necktie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 730, 'name': 'needle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 731, 'name': 'nest'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 732, 'name': 'newsstand'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 733, 'name': 'nightshirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 734, 'name': 'nosebag_(for_animals)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 735, 'name': 'noseband_(for_animals)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 736, 'name': 'notebook'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 737, 'name': 'notepad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 738, 'name': 'nut'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 739, 'name': 'nutcracker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 740, 'name': 'oar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 741, 'name': 'octopus_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 742, 'name': 'octopus_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 743, 'name': 'oil_lamp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 744, 'name': 'olive_oil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 745, 'name': 'omelet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 746, 'name': 'onion'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 747, 'name': 'orange_(fruit)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 748, 'name': 'orange_juice'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 749, 'name': 'oregano'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 750, 'name': 'ostrich'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 751, 'name': 'ottoman'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 752, 'name': 'overalls_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 753, 'name': 'owl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 754, 'name': 'packet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 755, 'name': 'inkpad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 756, 'name': 'pad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 757, 'name': 'paddle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 758, 'name': 'padlock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 759, 'name': 'paintbox'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 760, 'name': 'paintbrush'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 761, 'name': 'painting'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 762, 'name': 'pajamas'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 763, 'name': 'palette'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 764, 'name': 'pan_(for_cooking)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 765, 'name': 'pan_(metal_container)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 766, 'name': 'pancake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 767, 'name': 'pantyhose'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 768, 'name': 'papaya'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 769, 'name': 'paperclip'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 770, 'name': 'paper_plate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 771, 'name': 'paper_towel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 772, 'name': 'paperback_book'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 773, 'name': 'paperweight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 774, 'name': 'parachute'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 775, 'name': 'parakeet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 776, 'name': 'parasail_(sports)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 777, 'name': 'parchment'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 778, 'name': 'parka'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 779, 'name': 'parking_meter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 780, 'name': 'parrot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 781, 'name': 'passenger_car_(part_of_a_train)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 782, 'name': 'passenger_ship'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 783, 'name': 'passport'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 784, 'name': 'pastry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 785, 'name': 'patty_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 786, 'name': 'pea_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 787, 'name': 'peach'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 788, 'name': 'peanut_butter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 789, 'name': 'pear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 790, 'name': 'peeler_(tool_for_fruit_and_vegetables)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 791, 'name': 'pegboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 792, 'name': 'pelican'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 793, 'name': 'pen'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 794, 'name': 'pencil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 795, 'name': 'pencil_box'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 796, 'name': 'pencil_sharpener'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 797, 'name': 'pendulum'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 798, 'name': 'penguin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 799, 'name': 'pennant'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 800, 'name': 'penny_(coin)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 801, 'name': 'pepper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 802, 'name': 'pepper_mill'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 803, 'name': 'perfume'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 804, 'name': 'persimmon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 805, 'name': 'baby'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 806, 'name': 'pet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 807, 'name': 'petfood'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 808, 'name': 'pew_(church_bench)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 809, 'name': 'phonebook'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 810, 'name': 'phonograph_record'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 811, 'name': 'piano'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 812, 'name': 'pickle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 813, 'name': 'pickup_truck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 814, 'name': 'pie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 815, 'name': 'pigeon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 816, 'name': 'piggy_bank'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 817, 'name': 'pillow'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 818, 'name': 'pin_(non_jewelry)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 819, 'name': 'pineapple'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 820, 'name': 'pinecone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 821, 'name': 'ping-pong_ball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 822, 'name': 'pinwheel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 823, 'name': 'tobacco_pipe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 824, 'name': 'pipe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 825, 'name': 'pistol'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 826, 'name': 'pita_(bread)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 827, 'name': 'pitcher_(vessel_for_liquid)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 828, 'name': 'pitchfork'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 829, 'name': 'pizza'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 830, 'name': 'place_mat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 831, 'name': 'plate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 832, 'name': 'platter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 833, 'name': 'playing_card'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 834, 'name': 'playpen'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 835, 'name': 'pliers'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 836, 'name': 'plow_(farm_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 837, 'name': 'pocket_watch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 838, 'name': 'pocketknife'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 839, 'name': 'poker_(fire_stirring_tool)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 840, 'name': 'pole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 841, 'name': 'police_van'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 842, 'name': 'polo_shirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 843, 'name': 'poncho'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 844, 'name': 'pony'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 845, 'name': 'pool_table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 846, 'name': 'pop_(soda)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 847, 'name': 'portrait'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 848, 'name': 'postbox_(public)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 849, 'name': 'postcard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 850, 'name': 'poster'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 851, 'name': 'pot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 852, 'name': 'flowerpot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 853, 'name': 'potato'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 854, 'name': 'potholder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 855, 'name': 'pottery'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 856, 'name': 'pouch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 857, 'name': 'power_shovel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 858, 'name': 'prawn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 859, 'name': 'printer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 860, 'name': 'projectile_(weapon)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 861, 'name': 'projector'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 862, 'name': 'propeller'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 863, 'name': 'prune'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 864, 'name': 'pudding'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 865, 'name': 'puffer_(fish)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 866, 'name': 'puffin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 867, 'name': 'pug-dog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 868, 'name': 'pumpkin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 869, 'name': 'puncher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 870, 'name': 'puppet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 871, 'name': 'puppy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 872, 'name': 'quesadilla'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 873, 'name': 'quiche'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 874, 'name': 'quilt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 875, 'name': 'rabbit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 876, 'name': 'race_car'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 877, 'name': 'racket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 878, 'name': 'radar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 879, 'name': 'radiator'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 880, 'name': 'radio_receiver'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 881, 'name': 'radish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 882, 'name': 'raft'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 883, 'name': 'rag_doll'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 884, 'name': 'raincoat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 885, 'name': 'ram_(animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 886, 'name': 'raspberry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 887, 'name': 'rat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 888, 'name': 'razorblade'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 889, 'name': 'reamer_(juicer)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 890, 'name': 'rearview_mirror'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 891, 'name': 'receipt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 892, 'name': 'recliner'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 893, 'name': 'record_player'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 894, 'name': 'red_cabbage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 895, 'name': 'reflector'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 896, 'name': 'remote_control'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 897, 'name': 'rhinoceros'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 898, 'name': 'rib_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 899, 'name': 'rifle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 900, 'name': 'ring'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 901, 'name': 'river_boat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 902, 'name': 'road_map'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 903, 'name': 'robe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 904, 'name': 'rocking_chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 905, 'name': 'roller_skate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 906, 'name': 'Rollerblade'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 907, 'name': 'rolling_pin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 908, 'name': 'root_beer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 909, 'name': 'router_(computer_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 910, 'name': 'rubber_band'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 911, 'name': 'runner_(carpet)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 912, 'name': 'plastic_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 913, 'name': 'saddle_(on_an_animal)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 914, 'name': 'saddle_blanket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 915, 'name': 'saddlebag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 916, 'name': 'safety_pin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 917, 'name': 'sail'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 918, 'name': 'salad'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 919, 'name': 'salad_plate'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 920, 'name': 'salami'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 921, 'name': 'salmon_(fish)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 922, 'name': 'salmon_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 923, 'name': 'salsa'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 924, 'name': 'saltshaker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 925, 'name': 'sandal_(type_of_shoe)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 926, 'name': 'sandwich'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 927, 'name': 'satchel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 928, 'name': 'saucepan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 929, 'name': 'saucer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 930, 'name': 'sausage'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 931, 'name': 'sawhorse'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 932, 'name': 'saxophone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 933, 'name': 'scale_(measuring_instrument)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 934, 'name': 'scarecrow'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 935, 'name': 'scarf'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 936, 'name': 'school_bus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 937, 'name': 'scissors'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 938, 'name': 'scoreboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 939, 'name': 'scrambled_eggs'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 940, 'name': 'scraper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 941, 'name': 'scratcher'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 942, 'name': 'screwdriver'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 943, 'name': 'scrubbing_brush'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 944, 'name': 'sculpture'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 945, 'name': 'seabird'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 946, 'name': 'seahorse'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 947, 'name': 'seaplane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 948, 'name': 'seashell'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 949, 'name': 'seedling'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 950, 'name': 'serving_dish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 951, 'name': 'sewing_machine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 952, 'name': 'shaker'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 953, 'name': 'shampoo'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 954, 'name': 'shark'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 955, 'name': 'sharpener'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 956, 'name': 'Sharpie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 957, 'name': 'shaver_(electric)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 958, 'name': 'shaving_cream'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 959, 'name': 'shawl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 960, 'name': 'shears'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 961, 'name': 'sheep'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 962, 'name': 'shepherd_dog'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 963, 'name': 'sherbert'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 964, 'name': 'shield'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 965, 'name': 'shirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 966, 'name': 'shoe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 967, 'name': 'shopping_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 968, 'name': 'shopping_cart'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 969, 'name': 'short_pants'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 970, 'name': 'shot_glass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 971, 'name': 'shoulder_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 972, 'name': 'shovel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 973, 'name': 'shower_head'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 974, 'name': 'shower_curtain'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 975, 'name': 'shredder_(for_paper)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 976, 'name': 'sieve'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 977, 'name': 'signboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 978, 'name': 'silo'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 979, 'name': 'sink'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 980, 'name': 'skateboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 981, 'name': 'skewer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 982, 'name': 'ski'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 983, 'name': 'ski_boot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 984, 'name': 'ski_parka'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 985, 'name': 'ski_pole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 986, 'name': 'skirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 987, 'name': 'sled'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 988, 'name': 'sleeping_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 989, 'name': 'sling_(bandage)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 990, 'name': 'slipper_(footwear)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 991, 'name': 'smoothie'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 992, 'name': 'snake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 993, 'name': 'snowboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 994, 'name': 'snowman'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 995, 'name': 'snowmobile'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 996, 'name': 'soap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 997, 'name': 'soccer_ball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 998, 'name': 'sock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 999, 'name': 'soda_fountain'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1000, 'name': 'carbonated_water'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1001, 'name': 'sofa'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1002, 'name': 'softball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1003, 'name': 'solar_array'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1004, 'name': 'sombrero'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1005, 'name': 'soup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1006, 'name': 'soup_bowl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1007, 'name': 'soupspoon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1008, 'name': 'sour_cream'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1009, 'name': 'soya_milk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1010, 'name': 'space_shuttle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1011, 'name': 'sparkler_(fireworks)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1012, 'name': 'spatula'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1013, 'name': 'spear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1014, 'name': 'spectacles'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1015, 'name': 'spice_rack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1016, 'name': 'spider'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1017, 'name': 'sponge'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1018, 'name': 'spoon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1019, 'name': 'sportswear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1020, 'name': 'spotlight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1021, 'name': 'squirrel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1022, 'name': 'stapler_(stapling_machine)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1023, 'name': 'starfish'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1024, 'name': 'statue_(sculpture)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1025, 'name': 'steak_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1026, 'name': 'steak_knife'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1027, 'name': 'steamer_(kitchen_appliance)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1028, 'name': 'steering_wheel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1029, 'name': 'stencil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1030, 'name': 'stepladder'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1031, 'name': 'step_stool'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1032, 'name': 'stereo_(sound_system)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1033, 'name': 'stew'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1034, 'name': 'stirrer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1035, 'name': 'stirrup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1036, 'name': 'stockings_(leg_wear)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1037, 'name': 'stool'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1038, 'name': 'stop_sign'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1039, 'name': 'brake_light'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1040, 'name': 'stove'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1041, 'name': 'strainer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1042, 'name': 'strap'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1043, 'name': 'straw_(for_drinking)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1044, 'name': 'strawberry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1045, 'name': 'street_sign'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1046, 'name': 'streetlight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1047, 'name': 'string_cheese'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1048, 'name': 'stylus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1049, 'name': 'subwoofer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1050, 'name': 'sugar_bowl'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1051, 'name': 'sugarcane_(plant)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1052, 'name': 'suit_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1053, 'name': 'sunflower'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1054, 'name': 'sunglasses'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1055, 'name': 'sunhat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1056, 'name': 'sunscreen'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1057, 'name': 'surfboard'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1058, 'name': 'sushi'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1059, 'name': 'mop'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1060, 'name': 'sweat_pants'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1061, 'name': 'sweatband'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1062, 'name': 'sweater'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1063, 'name': 'sweatshirt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1064, 'name': 'sweet_potato'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1065, 'name': 'swimsuit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1066, 'name': 'sword'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1067, 'name': 'syringe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1068, 'name': 'Tabasco_sauce'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1069, 'name': 'table-tennis_table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1070, 'name': 'table'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1071, 'name': 'table_lamp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1072, 'name': 'tablecloth'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1073, 'name': 'tachometer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1074, 'name': 'taco'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1075, 'name': 'tag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1076, 'name': 'taillight'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1077, 'name': 'tambourine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1078, 'name': 'army_tank'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1079, 'name': 'tank_(storage_vessel)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1080, 'name': 'tank_top_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1081, 'name': 'tape_(sticky_cloth_or_paper)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1082, 'name': 'tape_measure'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1083, 'name': 'tapestry'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1084, 'name': 'tarp'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1085, 'name': 'tartan'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1086, 'name': 'tassel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1087, 'name': 'tea_bag'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1088, 'name': 'teacup'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1089, 'name': 'teakettle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1090, 'name': 'teapot'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1091, 'name': 'teddy_bear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1092, 'name': 'telephone'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1093, 'name': 'telephone_booth'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1094, 'name': 'telephone_pole'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1095, 'name': 'telephoto_lens'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1096, 'name': 'television_camera'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1097, 'name': 'television_set'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1098, 'name': 'tennis_ball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1099, 'name': 'tennis_racket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1100, 'name': 'tequila'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1101, 'name': 'thermometer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1102, 'name': 'thermos_bottle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1103, 'name': 'thermostat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1104, 'name': 'thimble'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1105, 'name': 'thread'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1106, 'name': 'thumbtack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1107, 'name': 'tiara'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1108, 'name': 'tiger'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1109, 'name': 'tights_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1110, 'name': 'timer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1111, 'name': 'tinfoil'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1112, 'name': 'tinsel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1113, 'name': 'tissue_paper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1114, 'name': 'toast_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1115, 'name': 'toaster'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1116, 'name': 'toaster_oven'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1117, 'name': 'toilet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1118, 'name': 'toilet_tissue'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1119, 'name': 'tomato'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1120, 'name': 'tongs'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1121, 'name': 'toolbox'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1122, 'name': 'toothbrush'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1123, 'name': 'toothpaste'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1124, 'name': 'toothpick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1125, 'name': 'cover'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1126, 'name': 'tortilla'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1127, 'name': 'tow_truck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1128, 'name': 'towel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1129, 'name': 'towel_rack'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1130, 'name': 'toy'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1131, 'name': 'tractor_(farm_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1132, 'name': 'traffic_light'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1133, 'name': 'dirt_bike'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1134, 'name': 'trailer_truck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1135, 'name': 'train_(railroad_vehicle)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1136, 'name': 'trampoline'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1137, 'name': 'tray'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1138, 'name': 'tree_house'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1139, 'name': 'trench_coat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1140, 'name': 'triangle_(musical_instrument)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1141, 'name': 'tricycle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1142, 'name': 'tripod'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1143, 'name': 'trousers'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1144, 'name': 'truck'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1145, 'name': 'truffle_(chocolate)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1146, 'name': 'trunk'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1147, 'name': 'vat'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1148, 'name': 'turban'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1149, 'name': 'turkey_(bird)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1150, 'name': 'turkey_(food)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1151, 'name': 'turnip'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1152, 'name': 'turtle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1153, 'name': 'turtleneck_(clothing)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1154, 'name': 'typewriter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1155, 'name': 'umbrella'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1156, 'name': 'underwear'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1157, 'name': 'unicycle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1158, 'name': 'urinal'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1159, 'name': 'urn'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1160, 'name': 'vacuum_cleaner'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1161, 'name': 'valve'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1162, 'name': 'vase'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1163, 'name': 'vending_machine'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1164, 'name': 'vent'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1165, 'name': 'videotape'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1166, 'name': 'vinegar'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1167, 'name': 'violin'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1168, 'name': 'vodka'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1169, 'name': 'volleyball'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1170, 'name': 'vulture'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1171, 'name': 'waffle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1172, 'name': 'waffle_iron'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1173, 'name': 'wagon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1174, 'name': 'wagon_wheel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1175, 'name': 'walking_stick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1176, 'name': 'wall_clock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1177, 'name': 'wall_socket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1178, 'name': 'wallet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1179, 'name': 'walrus'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1180, 'name': 'wardrobe'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1181, 'name': 'wasabi'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1182, 'name': 'automatic_washer'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1183, 'name': 'watch'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1184, 'name': 'water_bottle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1185, 'name': 'water_cooler'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1186, 'name': 'water_faucet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1187, 'name': 'water_filter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1188, 'name': 'water_heater'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1189, 'name': 'water_jug'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1190, 'name': 'water_gun'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1191, 'name': 'water_scooter'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1192, 'name': 'water_ski'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1193, 'name': 'water_tower'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1194, 'name': 'watering_can'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1195, 'name': 'watermelon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1196, 'name': 'weathervane'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1197, 'name': 'webcam'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1198, 'name': 'wedding_cake'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1199, 'name': 'wedding_ring'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1200, 'name': 'wet_suit'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1201, 'name': 'wheel'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1202, 'name': 'wheelchair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1203, 'name': 'whipped_cream'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1204, 'name': 'whiskey'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1205, 'name': 'whistle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1206, 'name': 'wick'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1207, 'name': 'wig'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1208, 'name': 'wind_chime'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1209, 'name': 'windmill'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1210, 'name': 'window_box_(for_plants)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1211, 'name': 'windshield_wiper'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1212, 'name': 'windsock'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1213, 'name': 'wine_bottle'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1214, 'name': 'wine_bucket'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1215, 'name': 'wineglass'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1216, 'name': 'wing_chair'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1217, 'name': 'blinder_(for_horses)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1218, 'name': 'wok'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1219, 'name': 'wolf'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1220, 'name': 'wooden_spoon'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1221, 'name': 'wreath'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1222, 'name': 'wrench'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1223, 'name': 'wristband'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1224, 'name': 'wristlet'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1225, 'name': 'yacht'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1226, 'name': 'yak'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1227, 'name': 'yogurt'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1228, 'name': 'yoke_(animal_equipment)'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1229, 'name': 'zebra'} ,
    {'color': [220, 20, 60], 'isthing': 1, 'id': 1230, 'name': 'zucchini'} ,
    ]



def _get_tao_image_meta():

    thing_ids = [k["id"] for k in TAO_CATEGORIES]
    assert len(thing_ids) == 302, len(thing_ids)
    # Mapping from the incontiguous category id to a contiguous id in [0, C-1]
    thing_dataset_id_to_contiguous_id = {k: i for i, k in enumerate(thing_ids)}
    thing_classes = [k["name"] for k in TAO_CATEGORIES]
    ret = {
        "thing_dataset_id_to_contiguous_id": thing_dataset_id_to_contiguous_id,
        "thing_classes": thing_classes,
    }
    return ret

