#!/bin/bash
#DATALOADER.SAMPLER_TRAIN "" \
set -e

BASE_LR_LIST=(0.0001 0.01)

for BASE_LR in "${BASE_LR_LIST[@]}"; do
    echo "Running experiment with BASE_LR: $BASE_LR"
    
    PORT=38000
    
    CUDA_VISIBLE_DEVICES=0,1,2,3 python3 detectron2/projects/train_net.py \
        --num-gpus 4 \
        --resume \
        --dist-url=tcp://127.0.0.1:$PORT \
        --config-file detectron2/projects/configs/images/Lite/lora.yaml \
        DATASETS.TRAIN '("vg_syn",)' \
        DATASETS.TEST '("d3_intra_scenario", "omnilabel_o365_val")' \
        TEST.EVAL_PERIOD 15000 \
        SOLVER.CHECKPOINT_PERIOD 15000 \
        MODEL.HIER_TRAINING True \
        MODEL.LORA True \
        MODEL.LORA_RANK 16 \
        MODEL.LORA_ALPHA 16 \
        SOLVER.IMS_PER_BATCH 16 \
        SOLVER.BASE_LR $BASE_LR \
	    SOLVER.MAX_ITER 200000 \
        SOLVER.TEXTENCODER_MULTIPLIER 0.05 \
        SOLVER.WEIGHT_DECAY 0.0001 \
        DATALOADER.DATASET_RATIO '[1.0,]' \
        DATALOADER.DATASET_BS '[2.0,]' \
        MODEL.HIER_PP True \
        WANDB_PROJECT "himod" \
        WANDB_NAME "vg_query_kv_cd_dec_128" \
        OUTPUT_DIR "/data/sojungan/exp/lora_lr"
    
    echo "Completed experiment with BASE_LR: $BASE_LR"
    echo "----------------------------------------"
done

echo "All learning rate experiments completed!"