# Mixture of Modality Knowledge Experts for Robust Multi-modal Knowledge Graph Completion

> Official implementation of paper "Mixture of Modality Knowledge Experts for Robust Multi-modal Knowledge Graph Completion". You can follow the instructions to reproduce our experiments.


## Overview
![model](resource/model.png)

## Dependencies
- Python==3.9
- numpy==1.24.2
- scikit_learn==1.2.2
- torch==2.0.0
- tqdm==4.64.1



## Train and Evaluation

You can refer to the training scripts in `scripts/train.sh` to reproduce our experiment results. Here is an example for DB15K dataset.

```bash
nohup python train_moe_disen.py --cuda 0 --lr 0.001 --mu 0.0001 --dim 200 --dataset MKG-W --epochs 2000 > log.txt &

nohup python train_moe_disen.py --cuda 1 --lr 0.0005 --mu 0.0001 --dim 300 --dataset MKG-Y --epochs 2000 > log.txt &
```
The evaluation results will be printed in the command line after training.

