from rsome import ro as ro            
import rsome as rso
import numpy.random as rd
import numpy as np
import rsome.grb_solver as gb

import gurobipy as gp
from gurobipy import GRB

from timer import Benchmark

def nominal_portfolio(r):
    n = len(r) 
    solver = gp.Model('nominal_solver')
    solver.setParam('OutputFlag', 0)


    i_ = [i for i in range(n)]
    x = solver.addVars(i_, lb = 0, name='x')

    # sum of x = 1
    solver.addConstr(sum(x[i] for i in i_) == 1)

    # max x^Tr
    solver.setObjective(sum(x[i] * r[i] for i in i_), GRB.MAXIMIZE)
    
    solver.update()
    solver.optimize()
    return solver

def sample_robust(rs): 
    m = len(rs)
    n = len(rs[0]) 
    solver = gp.Model('nominal_solver')
    solver.setParam('OutputFlag', 0)


    i_ = [i for i in range(n)]
    x = solver.addVars(i_, lb = 0, name='x')

    q = solver.addVar(lb = 0, name='q')

    # sum of x = 1
    solver.addConstr(sum(x[i] for i in i_) == 1)

    for r in rs:
        solver.addConstr(sum(x[i] * r[i] for i in i_) >= q)

    # max x^Tr
    solver.setObjective(q, GRB.MAXIMIZE)
    
    solver.update()
    solver.optimize()
    return solver

def robust(r, std, L, timeit = False):
    timer = Benchmark()
    timer.__enter__()

    solver = ro.Model('robust_solver')

    n = len(r)

    x = solver.dvar(n)
    u = solver.rvar(n)
    q = solver.dvar()

    solver.st(x >= 0)
    solver.st(sum(x) == 1)

    uset = (rso.norm(u) <= L, rso.norm(u,1) <= 1)
    solver.st( (q <= sum(x[i] * (r[i] + std[i] * u[i]) for i in range(n))).forall(uset))
    
    solver.max(q)
    
    solver.solve(gb)

    runtime = timer.__exit__() 
    if timeit: return solver, solver.get(), x.get(), runtime
    return solver, solver.get(), x.get()