# AROID: Improving Adversarial Robustness through Online Instance-wise Data Augmentation	
This repository contains the code of algorithm, **Adversarial Robustness by Online Instance-wise Data-augmentation (AROID)**, and pre-trained models from the paper "AROID: Improving Adversarial Robustness through Online Instance-wise Data Augmentation".

# Files

* `data`: dataset files
* `model`: model checkpoints
  * `trained`: saved model checkpoints
* `output`: experiment logs
* `src`: source code
  * `train.py`: training models
  * `adversary.py`: evaluating adversarial robustness
  * `utils`: shared utilities such as training, evaluation, log, printing, adversary, multiprocessing distribution
    * `train.py`: **implementation code of AT and AROID**.
  * `model`: model architectures and loss
    * `policy_net.py`: the architecture of policy model.
  * `data`: data processing
    * `policy.py`: policy sampling and sub-policy decoder
  * `config`: configurations for training and adversarial evaluation



# Requirements

### Development environment

The development environment is:

1. Python 3.8.13
2. PyTorch 1.11.0 + torchvision 0.12.0

The remaining dependencies are specified in the file `requirements.txt` and can be easily installed via the command:

```p
pip install -r requirements.txt
```

### Data

The simplest way to prepare the dataset is to add `--download` in the running command and the program will download the data files automatically. This functionality currently doesn't support the dataset Imagenette. One need to manually download [Imagenette](https://s3.amazonaws.com/fast-ai-imageclas/imagenette.tgz) and move (extract) it into `/data` directory.

### Affinity Model

Training with AROID requires a pre-trained clean model, named Affinity model in the paper, to compute the Affinity metric. We currently do not provide these pre-trained models due to the anonymity requirement, but will provide upon accepted. To prepare these models, one can train, e.g., a WideResNet34-10 as the Affinity model by running the following commands:

```python
python src/train.py -a wresnet --depth 34 --width 10 --max_iter 0 --epochs 40 --annealing 20 30 -ei 0
```

The trained model will be saved in `model/trained/log/XXXX.pth.tar`. Finally, move the model to `/model/std/{dataset}-{arch}.pth.tar`, e.g., `CIFAR10-wrn34.pth.tar` for WideResNet34-10 on CIFAR10. Please refer to `/src/config/train.py` for the architecture names specified in the hyperparameter `std_ref`.

# Training

To reproduce our result of WideResNet34-10 on CIFAR10, run:

```python
python src/train.py -a wresnet --depth 34 --width 10 -aug auto --std_ref wrn34 --aff_coef 0.4 0.2 0.1 --div_coef 0.8 --div_limits 0.1 0.3
```

To reproduce our result of ViT-B/16 on Imagenette, run:

```python
python src/train.py -a vit-b -ps 16 -d inte --pretrained -wd 0.0001 --epochs 40 --annealing 36 38 --clip_grad -aug auto --aff_coef 0.3 --div_coef 0.8 --div_limits 0.2 0.3 -pb vit-b --std_ref vit-b --plr 0.1
```

To reproduce our result of PreAct ResNet18 on SVHN, run:

```python
python src/train.py -d svhn --alpha 1 -ws --lr 0.01 -aug auto --aff_coef 0.01 --div_coef 0.3 --div_limits 0.3 0.3
```

There are also many other hyperparameters allowed to be specified in the running command in order to control the training. The shared hyperparameters, between training and evaluation are stored in the `src/config/config.py` and the task-specific hyperparameters are defined in the corresponding configuration file under the `src/config` folder. Please refer to the specific configuration file for the explanation and available options.

# Evaluation

For each training, the checkpoints will be saved in `model/trained/{log}` where {log} is the name of the experiment logbook (by default, is `log`). Each instance of training is tagged with a unique identifier, found in the logbook `output/log/{log}.json`, and that id is later used to load the well-trained model for the evaluation.

To evaluate the robustness of the "best" checkpoint against PGD50, run:

```
python src/adversary.py 0000 -v pgd -a PGD --max_iter 50
```

Similarly against AutoAttack (AA), run:

```
python src/adversary.py 0000 -v pgd -a AA
```

where "0000" should be replaced the real identifier to be evaluated.

# Dependencies

* the code of Wide ResNet is from [RobustBench](https://github.com/RobustBench/robustbench).
* the code of PreAct ResNet is from [Alleviate-Robust_Overfitting](https://github.com/VITA-Group/Alleviate-Robust-Overfitting).
* the code of AWP is modified from [AWP](https://github.com/csdongxian/AWP).
* the code of ViTs is from [When-Adversarial-Training-Meets-Vision-Transformers](https://github.com/mo666666/When-Adversarial-Training-Meets-Vision-Transformers).
* AutoAttack is implemented by the [original work](https://github.com/fra31/auto-attack).

# Pre-trained Models

to be updated upon accepted.