import argparse
import json
import os
 
import cv2
import numpy as np
from IPython import embed


ref_pairs = [
    [3,4],[6,7]
]

pose_pairs = [
    [0, 1], [0, 15], [0, 16],
    [15, 17],
    [16, 18],
    [1, 2], [1, 5], [1, 8],
    [2, 3],
    [3, 4],
    [5, 6],
    [6, 7],
    [8, 9], [8, 12],
    [9, 10],
    [10, 11],
    [11, 22], [11, 24],
    [22, 23],
    [12, 13],
    [13, 14],
    [14, 21], [14, 19],
    [19, 20]
]
 

hand_pairs = [
    [0, 1], [0, 5], [0, 9], [0, 13], [0, 17],
    [1, 2],
    [2, 3],
    [3, 4],
    [5, 6], [6, 7], [7, 8],
    [9, 10], [10, 11], [11, 12],
    [13, 14], [14, 15], [15, 16],
    [17, 18], [18, 19], [19, 20]
]
 

pose_colors = [
    (255., 0., 85.), (255., 0., 0.), (255., 85., 0.), (255., 170., 0.),
    (255., 255., 0.), (170., 255., 0.), (85., 255., 0.), (0., 255., 0.),
    (255., 0., 0.), (0., 255., 85.), (0., 255., 170.), (0., 255., 255.),
    (0., 170., 255.), (0., 85., 255.), (0., 0., 255.), (255., 0., 170.),
    (170., 0., 255.), (255., 0., 255.), (85., 0., 255.), (0., 0., 255.),
    (0., 0., 255.), (0., 0., 255.), (0., 255.,
                                     255.), (0., 255., 255.), (0., 255., 255.)
]
 
hand_colors = [
    (100., 100., 100.),
    (100, 0, 0),
    (150, 0, 0),
    (200, 0, 0), (255, 0, 0), (100, 100, 0), (150,
                                              150, 0), (200, 200, 0), (255, 255, 0),
    (0, 100, 50), (0, 150, 75), (0, 200, 100), (0,
                                                255, 125), (0, 50, 100), (0, 75, 150),
    (0, 100, 200), (0, 125, 255), (100, 0, 100), (150, 0, 150),
    (200, 0, 200), (255, 0, 255)
]
 
 
pts = {}
def handle_json(jsonfile):
 
    
 
    with open(jsonfile, 'r') as f:
        data = json.load(f)
    
    name = jsonfile.split('/')[-1][:-15]
    
    pts[name] = []
    if len(data['people'])==0:
        
        return name
    for d in [data['people'][0]]:
        kpt = np.array(d['pose_keypoints_2d']).reshape((25, 3))
        for p in ref_pairs:
            pt1 = tuple(list(map(int, kpt[p[0], 0:2])))
            c1 = kpt[p[0], 2]
            pt2 = tuple(list(map(int, kpt[p[1], 0:2])))
            c2 = kpt[p[1], 2]
            
 
            if c1 == 0.0 or c2 == 0.0:
                continue
            pts[name].append([pt1,pt2])
    return None
            
            
            
            
            
            
        
        
        
        
        
        
 
        
 
        
        
 
        
        
 
        
        
        
        
        
        
        
 
        
 
        
        
 
        
        
 
    
    
 
    
    
 
if __name__ == '__main__':
 
    parser = argparse.ArgumentParser()
    parser.add_argument('--directory', type=str,
                        default='/data/hdd01/cxx/mdetr/yourefit/keypoint', help='keypoints json directory')
    opt = parser.parse_args()
    null_list = []
    for jsonfile in os.listdir(opt.directory):
        if jsonfile.endswith('.json'):
            name = handle_json(os.path.join(opt.directory, jsonfile))
            if name is not None:
                null_list.append(name)
    embed()
    
    