source("R/util.R")
source("R/arg.R")

library(furrr)
library(stringr)

# pre-specified parameter
dim_x <- opt$dim_x
dim_z <- opt$dim_z
dim_u <- opt$dim_u
nsample <- opt$nsample # number of samples
nsim <- opt$nsim # number of simulation rounds
drf <- opt$drf # drf
set.seed(opt$seed)

# generate data
fileprefix <- paste(nsample, nsim, dim_x, dim_z, dim_u, drf, sep = ",")
plan("multicore")
future_walk(
  seq(nsim),
  function(x) {
    data <- gen_data(nsample, dim_x, dim_z, dim_u, drf)

    write.table(
      data[[1]],
      sprintf("data/train-%s-batch%s", fileprefix, str_pad(x, nchar(nsim), pad = "0")),
      row.names = FALSE, col.names = FALSE, sep = ","
    )

    write.table(
      data[[2]],
      sprintf("data/test-%s-batch%s", fileprefix, str_pad(x, nchar(nsim), pad = "0")),
      row.names = FALSE, col.names = FALSE, sep = ","
    )
  },
  .options = furrr_options(seed = opt$seed)
)

