library(optparse)

option_list <- list(
  make_option(c("-x", "--dim_x"),
    type = "integer", default = NULL,
    help = "Confounding variales dimension", metavar = "integer"
  ),
  make_option(c("-z", "--dim_z"),
    type = "integer", default = NULL,
    help = "Treatment specific variables dimension", metavar = "integer"
  ),
  make_option(c("-u", "--dim_u"),
    type = "integer", default = NULL,
    help = "Outcome specific varaibles dimension", metavar = "integer"
  ),
  make_option(c("-n", "--nsample"),
    type = "integer", default = 1000,
    help = "Number of observations", metavar = "integer"
  ),
  make_option(c("-s", "--nsim"),
    type = "integer", default = 100,
    help = "Number of simulation run", metavar = "integer"
  ),
  make_option(c("-d", "--drf"),
    type = "character", default = NULL,
    help = "Name of dose response function", metavar = "character"
  ),
  make_option(c("-m", "--model"),
    type = "character", default = NULL,
    help = "Name of Model", metavar = "character"
  ),
  make_option(c("--seed"),
    type = "integer", default = 1234,
    help = "random seed", metavar = "integer"
  )
)

opt_parser <- OptionParser(option_list = option_list)
opt <- parse_args(opt_parser)


