# Can Watermarked LLMs Be Identified by Users via Crafted Prompts?
## Environment
- python 3.9
- pytorch
- `pip install -r requirements.txt`

## Repo Structure
``` apache
├── data/
│   ├── prompts/                # prompts for generation
│   │   ├── ngram-p1.txt
│   │   ├── ngram-p2.txt
│   │   ├── fixkey-p1.txt
│   │   ├── fixkey-p2.txt
│   │   ├── 5gram-p1.txt
│   │   └── 5gram-p2.txt
│   │
│   ├── logits/                 # generated logits
│   │   └── {condition}-{p1 / p2}-logits-{model_name}.pickle
│   │
│   └── results/                # Results for sampling and experiments
│       ├── prob1/              # Sampling results for Water-Prob-V1
│       │   ├── {Watermarking_Algorithm}-p1-*.json
│       │   ├── {Watermarking_Algorithm}-p2-*.json
│       │   └── ...
│       ├── prob2/              # Sampling results for Water-Prob-V2
│       │   ├── {Watermarking_Algorithm}-p1-*.json
│       │   ├── {Watermarking_Algorithm}-p2-*.json
│       │   └── ...
│       └── csv/                # Experiment results
│           ├── {Watermarking_Algorithm}-{WaterProb Method}-results/
│           └── ...
│
├── scripts/
│   ├── sampling/               # Sampling related scripts
│   │   ├── Aar_sampling_batch_prob1.py
│   │   ├── Aar_sampling_batch_prob2.py
│   │   ├── DIP_sampling_batch_prob1.py
│   │   ├── DIP_sampling_batch_prob2.py
│   │   └── ...
│   │
│   ├── experiments/            # Experiment analysis related scripts
│   │   ├── Aar_experiments_prob1.py
│   │   ├── Aar_experiments_prob2.py
│   │   ├── DIP_experiments_prob1.py
│   │   ├── DIP_experiments_prob2.py
│   │   ├── unwatermark_prob1_experiments.py
│   │   ├── unwatermark_prob2_experiments.py
│   │   ├── unwatermark_prob2_experiments_5gram.py
│   │   └── ...
│   │
│   └── utils/                  # Commonly used utils
│
├── README.md                   # Project description file
└── requirements.txt            # Python dependencies

```

## Step1: Generate logits for each model
- Prompts can be found in `data/prompts/`
- Generate logits of prompts for each model, and save them in `data/logits/`
- Get the logits in advance to simulate the real-world generation process and accelerate the sampling process
- Scripts can be found in `scripts/generation/`, you can refer to `generate_logits.sh` to manually run each script
- To generate all logits for all watermarking algorithms, run 
``` bash
cd scripts/generation
bash generate_logits.sh
```
- Generated logits will be saved as `.pickle` files in `data/logits/`

## Step2: Sampling
- Scripts can be found in `scripts/sampling/`, you can refer to `sampling.sh` to manually run each script
- To generate all samples for all watermarking algorithms & unwatermarked condition, run 
``` bash
cd scripts/sampling
bash sampling_pipeline.sh
```
- Sampling results for Water-Prob-V1 will be saved in `data/results/prob1/`; Water-Prob-V2 will be saved in `data/results/prob2/`.

## Step3: Result Calculation
- Scripts can be found in `scripts/experiments/`, you can refer to `experiment_pipeline.sh` to manually run each script
- To generate all experiments for all watermarking algorithms & unwatermarked condition, run
``` bash
cd scripts/experiment
bash experiment_pipeline.sh
```
- Experiment results will be saved as `.csv` files in specific folders in `data/results/csv/`
