import random
import numpy as np

def get_nums_from_passage(p):
    words = p.strip().split()
    nums = []
    nums_id = []
    for idx, word in enumerate(words):
        try:
            word = word.replace(',','').replace('$', '')
            num = eval(word)
            if isinstance(num, int) or isinstance(num, float):
                nums.append(num)
                nums_id.append(idx)
        except:
            continue
    return nums, nums_id


def generate_fp_nums_multiarith(orig_nums, repeat_time):
    # erase cannot be divided exactly
    nums_candis = []
    ks = [[1, 2, 3], [1, 2, 5], [1, 2, 7], [1, 3, 5]]
    for x0 in [1, 2, 3, 4, 5]:
        for k in ks:
            nums_tmp = k
            nums_tmp = [_ * x0 for _ in nums_tmp]
            nums_candis.append(nums_tmp)
    
    fp_repl_numbers_list = []
    num_repl = len(orig_nums)
    for num_var in range(repeat_time):
        idx_candi = random.randint(0, len(nums_candis) - 1)
        num_pick = sorted(nums_candis[idx_candi])
        num_order = np.argsort(orig_nums).tolist()
        cur_rdx = 0
        idx_ = 0
        fp_nums = [-1 for _ in range(num_repl)]
        while idx_ < num_repl:
            fp_nums[num_order[idx_]] = num_pick[cur_rdx]
            idx_ += 1
            if idx_ == num_repl:
                break
            if orig_nums[num_order[idx_]] != orig_nums[num_order[idx_ - 1]] or \
                orig_nums[num_order[idx_]] < 10:
                cur_rdx += 1
        
        fp_repl_numbers_list.append(fp_nums)
    
    return fp_repl_numbers_list


def fp_substitute(p, s_time)-> list: 

    orig_nums, nums_id = get_nums_from_passage(p)
    fp_nums_list = generate_fp_nums_multiarith(orig_nums, s_time)
    data_fp_list = []
    words = p.strip().split()
    for fp_idx, fp_nums in enumerate(fp_nums_list):
            q = []
            num_idx = 0
            for idx, word in enumerate(words):
                if idx in nums_id:
                    q.append(str(fp_nums[num_idx]))
                    if word[-1] == '.':
                        q[-1] += '.'
                    num_idx += 1
                else:
                    q.append(word)
            q = " ".join(q)
            item_fp = ({
                "Question": q,
                "Alignments": fp_nums,
            })
            data_fp_list.append(item_fp)

    return data_fp_list
