# ORA: OOD Detection with Relative Angles


## Setup

```bash
# create conda env and install dependencies
$ conda env create -f environment.yml
$ conda activate ORA
# set environmental variables
$ export DATASETS='data'
# download datasets and checkpoints
$ bash download.sh
```

Download ImageNet dataset manually [from](https://gist.github.com/bonlime/4e0d236cf98cd5b15d977dfa03a63643).

## Demo

CIFAR-10 Benchmark
```
python feat_extract.py --in-dataset CIFAR-10  --out-datasets SVHN iSUN dtd places365 --name resnet18-supcon  --model-arch resnet18-supcon

python run_cifar.py --in-dataset CIFAR-10  --out-datasets SVHN iSUN dtd places365 --name resnet18-supcon   --model-arch resnet18-supcon 
```

ImageNet Benchmark
```
python feat_extract_largescale.py --in-dataset imagenet --imagenet-root $IMAGENET --out-datasets inat sun50 places50 dtd  --name resnet50-supcon --model-arch resnet50-supcon

python run_imagenet.py --in-dataset imagenet  --out-datasets inat sun50 places50 dtd  --name resnet50-supcon  --model-arch resnet50-supcon
```
For the extended benchmark please adjust the feat_extract_largescale_<model_name>.py and run_imagenet_<model_name>.py files accordingly


ORA with model ensemble (before this, you need to save the in and out scores of the individual models)
```
python feat_extract_largescale.py --in-dataset imagenet --imagenet-root $IMAGENET --out-datasets inat sun50 places50 dtd  --name resnet50-supcon --model-arch resnet50-supcon

python run_imagenet_zoo.py --in-dataset imagenet  --out-datasets inat sun50 places50 dtd  --name resnet50-supcon  --model-arch resnet50-supcon
```

