rm(list = ls())
library(ExtDist)

path <- ""
res_path <- ""

source(paste0(path, "hyperbolic_functions.R"))

d <- 15
r <- 1.5
n <- 40
sig <- 0.5
center <- c(1, rep(0, d))

sens <- 2 * r / n
mu_list <- c(seq(0.1, 0.7, 0.1), 1, 1.5, 2)

res_list <- matrix(NA, nrow = length(mu_list), ncol = 8)
ind = 1
set.seed(31415)
for (mu in mu_list){
  lap_sig <- sens / log( (1 - pnorm(- mu / 2)) / pnorm(- mu / 2) )
  
  print(paste0("============ ", mu, " ============"))
  # dat <- rBall(n, center, r)
  dat <- rBall_uniform(n, center, r)
  print(Sys.time())
  true_p <- frechet_mean(dat)
  
  dist_list <- c()
  time_list <- c()
  for (i in 1:1000){
    start_1 <- Sys.time()
    p_dp <- rEWGauss(1, center, true_p, sig = sens/mu)
    start_2 <- Sys.time()
    p_dp_2 <- rRLap(1, true_p, sig = lap_sig)
    start_3 <- Sys.time()
    dist_list <- rbind(dist_list, c(dist_fn(true_p, p_dp), tryCatch(dist_fn(true_p, p_dp_2), error=function(err) NA)))
    time_list <- rbind(time_list, c(start_2 - start_1, start_3 - start_2))
  }
  
  dist_mean <- apply(dist_list, 2, function(x){
    x <- x[is.finite(x)]
    mean(x)
  })
  
  dist_std <- apply(dist_list, 2, function(x){
    x <- x[is.finite(x)]
    sd(x)
  })
  
  time_mean <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    mean(x)
  })
  
  time_std <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    sd(x)
  })
  
  
  print(c(dist_mean, dist_std))
  res_list[ind, ] <- c(dist_mean, dist_std, time_mean, time_std) 
  ind = ind + 1
}

res_list <- cbind(mu_list, res_list)
print(res_list)

# write.csv(res_list, file = paste0(res_path, "GDP_hyperbolic_", d, ".csv"), row.names = FALSE)
write.csv(round(res_list[,1:5], 3), file = paste0(res_path, "GDP_hyperbolic_", d, ".csv"), row.names = FALSE)