rm(list = ls())
library(ExtDist)

path <- ""
res_path <- ""

source(paste0(path, "spd_functions_le.R"))

d <- 5
r <- 1.5
n <- 40

sens <- 2 * r / n
mu_list <- c(seq(0.1, 0.7, 0.1), 1, 1.5, 2)

res_list <- matrix(NA, nrow = length(mu_list), ncol = 8)
ind = 1
set.seed(31415)
center <- diag(1, d)
for (mu in mu_list){
  lap_sig <- sens / log( (1 - pnorm(- mu / 2)) / pnorm(- mu / 2) )
  print(paste0("============ ", mu, " ============"))
  fix_point <- diag(rep(1, d))
  dat <- rSPD(n, d, r, center)
  print(Sys.time())
  true_p <- frechet_mean_le(dat, d)
  
  dist_list <- c()
  time_list <- c()
  for (i in 1:100){
    start_1 <- Sys.time()
    p_dp <- rSPD_dist_le(1, d, list(true_p), sigma = sens / mu, type = "gauss")[[1]]
    start_2 <- Sys.time()
    p_dp_2 <- rSPD_dist_le(1, d, list(true_p), sigma = lap_sig, type = "laplace")[[1]]
    start_3 <- Sys.time()
    dist_list <- rbind(dist_list, c(dist_le(true_p, p_dp), dist_le(true_p, p_dp_2)))
    time_list <- rbind(time_list, c(start_2 - start_1, start_3 - start_2))
  }
  
  dist_mean <- apply(dist_list, 2, function(x){
    x <- x[is.finite(x)]
    mean(x)
  })
  
  dist_std <- apply(dist_list, 2, function(x){
    x <- x[is.finite(x)]
    sd(x)
  })
  
  time_mean <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    mean(x)
  })
  
  time_std <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    sd(x)
  })
  
  
  print(c(dist_mean, dist_std))
  res_list[ind, ] <- c(dist_mean, dist_std, time_mean, time_std) 
  ind = ind + 1
}

res_list <- cbind(mu_list, res_list)

write.csv(res_list, file = paste0(res_path, "GDP_le_", d, ".csv"))