rm(list = ls())
library(ExtDist)

path <- ""
res_path <- ""

source(paste0(path, "spd_functions.R"))

vecd <- function(m){
  return(c(diag(m), sqrt(2)* m[upper.tri(m, diag = FALSE)]))
}


vecd_inverse <- function(u){
  m <- sqrt(1 + 8 * length(u))/ 2 - 0.5
  mat <- matrix(0, m, m)
  diag(mat) <- u[1:m]
  mat[upper.tri(mat, diag = FALSE)] <- u[-(1:m)] / sqrt(2)
  mat[lower.tri(mat)] <- t(mat)[lower.tri(mat)]
  return(mat)
}

n <- 40
r <- 1.5
nburn <- 1
mu <- 1
sens <- 2 * r / n
lap_sig <- sens / log( (1 - pnorm(- mu / 2)) / pnorm(- mu / 2) )
d_list <- c(2, 5, 7, 10, 13, 17,20, 23, 27, 30)

res_list <- matrix(NA, nrow = length(d_list), ncol = 4)
ind = 1
set.seed(31415)
for (d in d_list){
  print(paste0("============ ", d, " ============"))
  
  fix_point <- diag(rep(1, d))  
  true_p <- rSPD(n, d, Inf)[[1]]
  dist_list <- c()
  time_list <- c()
  for (i in 1:10){
    start_1 <- Sys.time()
    p_dp <- expm::expm( vecd_inverse( vecd(log_fn(fix_point, true_p)) + rnorm(d*(d+1)/2, 0, sd = sens / mu) ) )
    start_2 <- Sys.time()
    p_dp_2 <- rSPD_dist(1, d, mu = true_p, sigma = lap_sig, "laplace", n_burn = nburn * 10000)[[1]]
    start_3 <- Sys.time()
    time_list <- rbind(time_list, c(start_2 - start_1, start_3 - start_2))
    print(time_list[i, ])
  }

  
  time_mean <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    mean(x)
  })
  
  time_std <- apply(time_list, 2, function(x){
    x <- x[is.finite(x)]
    sd(x)
  })
  
  
  print(c(time_mean, time_std))
  res_list[ind, ] <- c(time_mean, time_std) 
  ind = ind + 1
}

res_list <- cbind(d_list, res_list)
write.csv(res_list, file = paste0(res_path, "GDP_time_", mu, ".csv"))