# Instance-aware 3D Semantic Segmentation powered by Shape Generators and Classifiers



## Installation

This repository is built on [OpenPCDet](https://github.com/open-mmlab/OpenPCDet). Please first follow the instructions in their github repo to install the pcdet. Or you can click here [INSTALL.md](docs/INSTALL.md) for the installation of `OpenPCDet`. 


## Dataset 
### Waymo Open Dataset
Please follow this [page](https://github.com/open-mmlab/OpenPCDet/blob/master/docs/GETTING_STARTED.md#waymo-open-dataset) to prepare the dataset.

### SemanticKITTI
Please download the dataset from the official website and put the `velodyne` and `label` files into `data/semantickitti`. 

### ScanNet 
Please follow the instructions in the [PointGruop](https://github.com/dvlab-research/PointGroup/tree/master#data-preparation) repo. 

## Run the code 
For Waymo Open Dataset, run
```
./waymo.sh
```

For SemanticKITTI, run
```
./kitti.sh
```


For ScanNet, run
```
./scannet.sh
```

## Useful File References
Here we list some useful file references where our core algorithms are located. 

### Instance Clustering 
Taking SemanticKITTI for an example, this part is in `pcdet/datasets/semantickitti/semantickitti_dataset.py, line 241-278`. 
Similar code can be found in `pcdet/datasets/waymo/waymo_dataset/py` and `pcdet/datasets/scannet/scannet_dataset/py`. 

### Instance Heads 
The core file is in `pcdet/models/dense_heads/point_seg_head_gen.py`. This file contains the per-voxel segmentation head, instance classification head, and shape reconstruction head. 


## LidarMultiNet Baseline 
This file is in `pcdet/models/backbones_3d/spconv_unet.py`. Line 94 is about the GCP. 
