# Elucidating the design space of deep stochastic processes for image enhancement

## Setting up

- setup wandb: `entity` and `project_name` in `config/core/default.yaml`
- download datasets to `data/`:
  - [FFHQ](https://www.kaggle.com/datasets/chelove4draste/ffhq-512x512) to `data/ffhq`
  - [ImageNet ILSVRC2012](https://www.image-net.org/challenges/LSVRC/2012/index.php) to `data/imagenet`
  - [LOL](https://daooshee.github.io/BMVC2018website/) to `data/LOL`
  - [Rain1400](https://xueyangfu.github.io/projects/cvpr2017.html) to `data/rain1400`
- setup python >=3.9 venv
- install requirements
- install `basicsr`: `pip install basicsr` and apply [the fix](https://github.com/XPixelGroup/BasicSR/issues/711#issuecomment-2892855824)
- install `ito-vision` library: `pip install ../ito_vision`

## Running

For example:

- `python train.py experiment=isr_ffhq/ir_sde`