import numpy as np
from basicsr.metrics.niqe import calculate_niqe


def NIQE(x):
    return [
        calculate_niqe(
            ((xi + 1.0) * 127.5)
            .clamp(0, 255)
            .permute((1, 2, 0))
            .numpy()
            .astype(np.uint8),
            crop_border=0,
            input_order="HWC",
        )
        for xi in x.cpu()
    ]
