# Factor Graph Optimization of Error-Correcting Codes for Belief Propagation Decoding

Implementation of the paper "Factor Graph Optimization of Error-Correcting Codes for Belief Propagation Decoding"
<!-- ["Factor Graph Optimization of Error-Correcting Codes for Belief Propagation Decoding"](https://arxiv.org/abs/2203.14966). -->

<p align="center">
<img src="Codes_DB/factor_graph_teaset.png" width="200px">
</p>

## Abstract

The design of optimal linear block codes capable of being efficiently decoded is of major concern, especially for short block lengths. As near
capacity-approaching codes, Low-Density ParityCheck (LDPC) codes possess several advantages
over other families of codes, the most notable being its efficient decoding via Belief Propagation.
While many LDPC code design methods exist, the
development of efficient sparse codes that meet
the constraints of modern short code lengths and
accommodate new channel models remains a challenge. In this work, we propose for the first time
a gradient-based data-driven approach for the design of sparse codes. We develop locally optimal
codes with respect to Belief Propagation decoding via the learning of the Factor graph under
channel noise simulations. This is performed via
a novel complete graph tensor representation of
the Belief Propagation algorithm, optimized over
finite fields via backpropagation and coupled with
an efficient line-search method. The proposed
approach is shown to outperform the decoding
performance of existing popular codes by orders
of magnitude and demonstrates the power of datadriven approaches for code design.

## Install
- pytorch
-  galois

## Script
Please run `python Main.py --help` for a full list of hyperparameters (description is given in Appendix A).

cmd example:   `python Main.py --code_type BCH --code_n 63 --code_k 45 --eps_scenario=3 --H_eps=1e-7`

## License
This repo is MIT licensed.
