from collections import OrderedDict
from copy import deepcopy
from math import sqrt

from run_parallel import run_parallel


family_idx = 50
family_name = "truncated_reseed"


base_config = {
    "optimizer_params": [{
        "name": "nesgd",
        "lr": [0.001],
        "spectral_scale": 1.0,
        "weight_decay": 0.0,
        "lr_schedule": "warmup-constant-linear",
        "warm_up_fraction": 0.05,
        "cool_down_fraction": 0.5,
        "truncate_loss": 3.2,
    }],
    "training_params": {
        "tokens_processed": 524288, # 2^19
        "val_tokens_processed": 8388608, #2^23
        "batch_size": 64,
        "num_epochs": 1,
        "context_length": 1024,
        "gradnorm": 0.0,
        "tensorcore_precision": "high",   #Can be highest, high, or medium
        "autocast": True,
        "mixed_precision": "bfloat16",
        "compile": True,
    },
    "logging_params": {
        "val_tokens_processed": 8388608,
        "log_step": 256,
        "val_step": 256,
        "save_ckpt_step": 512,
        "load_ckpt_step": 0,
        "keep_last": 2,
        "ckpt_dir": "",
    },
    "gpt_model": {
        "n_embd": 768,
        "n_layer": 12,
        "n_head": 12,
        "vocab_size": 50257,
        "flash_attention": True,
    },
    "dataset": {
        "name": "fineweb1B"
    },
    "seed": 42,
}

# Generate configs for this experiment.
tuned_lrs = {
    "nesgd-adam_infty-lmo-momo": {"muon": 0.03, "other": 3e-3},
    "nesgd-hybrid_prod-adam_2-lmo-momo": {"muon": 0.03, "other": 0.03},
    "nesgd-hybrid_prod-adam_2-momo": {"muon": 0.01, "other": 1e-2},
    "nesgd-adam_infty-momo": {"muon": 0.03, "other": 3e-4},
    "nesgd-lmo-momo": {"muon": 0.01, "other": 1e-3},
    "nesgd-hybrid_prod-momo": {"muon": 0.01, "other": 1e-4},
}
seeds = [43, 44]

# Sweep other lr.
experiment_configs = OrderedDict()
for alg, lrs in tuned_lrs.items():
    muon_lr, other_lr = lrs["muon"], lrs["other"]
    s = muon_lr / other_lr
    spectral_scale = s if "lmo" in alg else sqrt(s)

    opt_settings = {
        "name": alg + "-momo",
        "lr": [other_lr],
        "spectral_scale": spectral_scale,
    }

    for seed in seeds:
        current_config = deepcopy(base_config)
        current_config["optimizer_params"][0].update(dict(opt_settings))
        current_config["seed"] = seed
        run_name = f"{family_idx}_{family_name}/{alg}_{seed}"
        experiment_configs[run_name] = deepcopy(current_config)

# Launch runs in parallel.
run_parallel(experiment_configs)
