To start, setup up the virtual enviroment and install dependencies by running
```bash
 ./setup_env.sh
```

### Create a virtual environment and activate:
```bash
python3 -m venv gptopt
source gptopt/bin/activate
python3 -m pip install -e .
```

### Download datasets:
```bash
python3 process_data.py --name fineweb10B
python3 process_data.py --name slim_pajama
```

### Run an example:
```bash
bash job4.sh
```


To run experiments from the paper, run the numbered scripts in the home directory, i.e.
```bash
python3 47_tune_spectral_lr_all.py
```

After running all of the numbered scripts, plots can be reproduced by running the
scripts in final_plot_scripts/.

Note that the numbered python scripts are expecting to be run on a Slurm cluster, and
will launch training through Slurm commands.
