# Hypothesis Driven Coordinate Ascent (HDCA)

HDCA is a black box optimization method for training policies for control problems.

## Prerequisites for running HDCA

Our HDCA implementation relies on Python 3, OpenAI Gym 0.19.0, MuJoCo Pro 2.0, Numpy 1.20.3, Scipy 1.7.1, and the Pathos 0.2.8 library for multiprocessing.  

To install OpenAI Gym follow the instructions here:
https://github.com/openai/gym

For more information on Pathos see https://pathos.readthedocs.io/en/latest/pathos.html. 

For instructions on how to install MuJoCo, please refer to:
https://github.com/openai/mujoco-py

## Running HDCA

To train a policy for LunarLanderContinuous-v2, execute the following command: 

```
./scripts/LunarLanderContinuous.sh
```

## Rendering Trained Policy

To render the trained policy for the LunarLanderContinuous-v2 environment, execute the following command:

```
python3 ./code/simulateTrainedModel.py --env_name LunarLanderContinuous-v2 --render False --num_episodes 100 --max_ep_len 1000
```
