#!/bin/bash

cd ..

# custom config
DATA=/data/CVPR23_medfm/DATA
TRAINER=ZeroshotCLIP_dense

DATASET=$1
CFG=$2  # config file
res_dir=$3
id=$4

export CUDA_VISIBLE_DEVICES=2

DIR=output/evaluation/${TRAINER}/${DATASET}/${CFG}_240320
if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. Skip this job"
else
    echo "Run this job andsave the output to ${DIR}"
    python train_caption.py \
    --root ${DATA} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/zsclip/${CFG}.yaml \
    --output-dir ${DIR} \
    --eval-only \

fi

# bash zsclip.sh voc2007_distill rn101

