import torch
import torch.nn as nn
from torch.nn import functional as F
from torchvision.models._utils import IntermediateLayerGetter

from dassl.engine import TRAINER_REGISTRY, TrainerX
from dassl.optim import build_optimizer, build_lr_scheduler

from clip import clip
from clip.model import convert_weights

from .coop import load_clip_to_cpu
from .imagenet_templates import IMAGENET_TEMPLATES, IMAGENET_TEMPLATES_SELECT
from tqdm import tqdm
import numpy as np
import math
import time
import matplotlib.pyplot as plt


CUSTOM_TEMPLATES = {
    "OxfordPets": "a photo of a {}, a type of pet.",
    "OxfordFlowers": "a photo of a {}, a type of flower.",
    "FGVCAircraft": "a photo of a {}, a type of aircraft.",
    "DescribableTextures": "{} texture.",
    "EuroSAT": "a centered satellite photo of {}.",
    "StanfordCars": "a photo of a {}.",
    "Food101": "a photo of {}, a type of food.",
    "SUN397": "a photo of a {}.",
    "Caltech101": "a photo of a {}.",
    "UCF101": "a photo of a person doing {}.",
    "ImageNet": "a photo of a {}.",
    "ImageNetSketch": "a photo of a {}.",
    "ImageNetV2": "a photo of a {}.",
    "ImageNetA": "a photo of a {}.",
    "ImageNetR": "a photo of a {}."
}
label_names = [
    "person", "bicycle", "car", "motorcycle", "airplane", "bus", "train", "truck",
    "boat", "traffic light", "fire hydrant", "stop sign", "parking meter", "bench",
    "bird", "cat", "dog", "horse", "sheep", "cow", "elephant", "bear", "zebra", "giraffe",
    "backpack", "umbrella", "handbag", "tie", "suitcase", "frisbee", "skis", "snowboard",
    "sports ball", "kite", "baseball bat", "baseball glove", "skateboard", "surfboard",
    "tennis racket", "bottle", "wine glass", "cup", "fork", "knife", "spoon", "bowl",
    "banana", "apple", "sandwich", "orange", "broccoli", "carrot", "hot dog", "pizza",
    "donut", "cake", "chair", "couch", "potted plant", "bed", "dining table", "toilet",
    "tv", "laptop", "mouse", "remote", "keyboard", "cell phone", "microwave", "oven",
    "toaster", "sink", "refrigerator", "book", "clock", "vase", "scissors", "teddy bear",
    "hair drier", "toothbrush"
]

MEASURE_TIME = False
WTA = False
RESNET101 = True
DATASET = "COCO"

CLASS_ADAPT_GLOBAL = True
CLASS_ADAPT_LOCAL = True

TASK_ADAPT_GLOBAL = True
TASK_ADAPT_LOCAL = True

COCO_CUT = 32000 #1000~32000
#VOC_CUT = 32000 #1000~32000
VOC_CUT=0

K=3
GZSL=True
FEWSHOT=True
UNSEEN=False

VISUALIZE=True


def save_attmap(batch_idx,data_idx,image,patch_output,label, predict):
    
    print (image.shape,patch_output.shape,label.shape,predict.shape)
    
    folder_path = 'visualize_ours/'
    # 폴더가 없으면 생성
    
    #torch.Size([3, 448, 448]) torch.Size([196, 80]) torch.Size([80]) torch.Size([80])
    import os
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)

    label_names = [
        "person", "bicycle", "car", "motorcycle", "airplane", "bus", "train", "truck",
        "boat", "traffic light", "fire hydrant", "stop sign", "parking meter", "bench",
        "bird", "cat", "dog", "horse", "sheep", "cow", "elephant", "bear", "zebra", "giraffe",
        "backpack", "umbrella", "handbag", "tie", "suitcase", "frisbee", "skis", "snowboard",
        "sports ball", "kite", "baseball bat", "baseball glove", "skateboard", "surfboard",
        "tennis racket", "bottle", "wine glass", "cup", "fork", "knife", "spoon", "bowl",
        "banana", "apple", "sandwich", "orange", "broccoli", "carrot", "hot dog", "pizza",
        "donut", "cake", "chair", "couch", "potted plant", "bed", "dining table", "toilet",
        "tv", "laptop", "mouse", "remote", "keyboard", "cell phone", "microwave", "oven",
        "toaster", "sink", "refrigerator", "book", "clock", "vase", "scissors", "teddy bear",
        "hair drier", "toothbrush"
    ]
    
    SPATIAL_SIZE = 14
    IMAGE_SIZE = 448
    
    data_normalized = (image - image.min()) / (image.max() - image.min())
    image_to_display = data_normalized.permute(1, 2, 0).detach().cpu().numpy()
    active_labels_indices = np.where(label.detach().cpu().numpy() == 1)[0].tolist()
    
    
    for i, label_idx in enumerate(active_labels_indices):
        
        
        fig, ax = plt.subplots(figsize=(10, 10))
        ax.imshow(image_to_display)

        ax.axis('off')  # Turn off the axis
        plt.subplots_adjust(left=0, right=1, top=1, bottom=0)  # Remove the padding around the image

        # Save the figure with no padding and no border
        filename = f"batch:{batch_idx}_idx:{data_idx}_origin.png"
        plt.savefig(os.path.join(folder_path, filename), bbox_inches='tight', pad_inches=0)
        plt.close(fig)  # Close the plot to free memory
        
        
        values,indices = torch.topk(predict,5)
        # Convert to Python lists for easier writing to file
        values_list = values.tolist()
        indices_list = indices.tolist()

        # Write to a text file
        o_filename = f"batch:{batch_idx}_idx:{data_idx}_top5.txt"
        with open(os.path.join(folder_path, o_filename), 'w') as file:
            for value, index in zip(values_list, indices_list):
                file.write(f'Value: {value}, Index: {label_names[index]}\n')
        
        

        label_text = label_names[label_idx]

        fig, ax = plt.subplots(figsize=(10, 10))
        ax.imshow(image_to_display)

        # Reshape logits and add necessary singleton dimensions for batch and channel
        logits = patch_output[:, label_idx].reshape(1, 1, SPATIAL_SIZE, SPATIAL_SIZE)  # [1, 1, 14, 14]

        # Resize logits to match image spatial dimensions
        resized_spatial_logits = F.interpolate(logits, size=(IMAGE_SIZE, IMAGE_SIZE), mode='bilinear', align_corners=False)

        # Remove the extra dimensions and move to CPU for visualization
        resized_spatial_logits = resized_spatial_logits.squeeze().detach().cpu().numpy()

        # Overlay logits on the image as a heatmap
        ax.imshow(resized_spatial_logits, cmap='jet', alpha=0.5)  # Adjust alpha for transparency, cmap for color mapping

        ax.axis('off')  # Turn off the axis
        plt.subplots_adjust(left=0, right=1, top=1, bottom=0)  # Remove the padding around the image

        # Save the figure with no padding and no border
        filename = f"batch:{batch_idx}_idx:{data_idx}_label:{label_text}_predict:{predict[label_idx]}.png"
        plt.savefig(os.path.join(folder_path, filename), bbox_inches='tight', pad_inches=0)
        plt.close(fig)  # Close the plot to free memory


@TRAINER_REGISTRY.register()
class ZeroshotCLIP(TrainerX):
    def build_model(self):
        cfg = self.cfg
        classnames = self.dm.dataset.classnames

        print(f"Loading CLIP (backbone: {cfg.MODEL.BACKBONE.NAME})")
        clip_model = load_clip_to_cpu(cfg)
        clip_model.to(self.device)

        try:
            temp = CUSTOM_TEMPLATES[cfg.DATASET.NAME]
        except:
            print('!! WARNING: Not found template for {}'.format(cfg.DATASET.NAME))
            temp = "a photo of a {}."

        prompts = [temp.format(c.replace("_", " ")) for c in classnames]
        print(f"Prompts: {prompts}")
        prompts = torch.cat([clip.tokenize(p) for p in prompts])
        prompts = prompts.to(self.device)

        with torch.no_grad():
            text_features = clip_model.encode_text(prompts)
            text_features = text_features / text_features.norm(dim=-1, keepdim=True)

        self.text_features = text_features
        self.clip_model = clip_model

    def model_inference(self, image):
        image_features = self.clip_model.encode_image(image)
        image_features = image_features / image_features.norm(dim=-1, keepdim=True)
        logit_scale = self.clip_model.logit_scale.exp()
        logits = logit_scale * image_features @ self.text_features.t()

        return logits, None, None


def read_npy(numpy_file, device):
    all_features = np.load(numpy_file, allow_pickle=True)

    # for ii, l_n in enumerate(label_names):
    #     temp = torch.tensor(all_features[ii])
    #     if ii == 0:
    #         text_caption = temp[:16].unsqueeze(0)
    #     else:
    #         text_caption = torch.cat((text_caption, temp[:16].unsqueeze(0)),0) # 80 16 512

    print('load complete:', numpy_file)
    return torch.tensor(all_features).to(torch.float16).to(
        device)  # text_caption.to(device) #torch.tensor(all_features).to(device)


@TRAINER_REGISTRY.register()
class ZeroshotCLIP_dense(TrainerX):
    def build_model(self):
        cfg = self.cfg
        classnames = self.dm.dataset.classnames

        print(f"Loading CLIP (backbone: {cfg.MODEL.BACKBONE.NAME})")
        clip_model = load_clip_to_cpu(cfg)
        clip_model.to(self.device)

        try:
            temp = CUSTOM_TEMPLATES[cfg.DATASET.NAME]
        except:
            print('!! WARNING: Not found template for {}'.format(cfg.DATASET.NAME))
            temp = "a photo of a {}."

        prompts = [temp.format(c.replace("_", " ")) for c in classnames]
        print(f"Prompts: {prompts}")
        prompts = torch.cat([clip.tokenize(p) for p in prompts])
        prompts = prompts.to(self.device)

        with torch.no_grad():
            text_features = clip_model.encode_text(prompts)
            text_features = text_features / text_features.norm(dim=-1, keepdim=True)

        self.text_features = text_features
        self.clip_model = clip_model

        self.visual_encoder = IntermediateLayerGetter(self.clip_model.visual, {"layer4": "0"})
        self.positional_embedding = self.clip_model.visual.attnpool.positional_embedding[1::]
        self.v_linear_weight = self.clip_model.visual.attnpool.v_proj.weight
        self.v_linear_bias = self.clip_model.visual.attnpool.v_proj.bias
        self.c_linear_weight = self.clip_model.visual.attnpool.c_proj.weight
        self.c_linear_bias = self.clip_model.visual.attnpool.c_proj.bias

        if DATASET == "COCO":
            if RESNET101:
                self.caption = read_npy('COCO_caption_selection_101.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                self.caption_local = read_npy('COCO_caption_selection_local_101.npy', self.device)
                self.caption_local = self.caption_local / self.caption_local.norm(dim=-1, keepdim=True)

                
                self._multi_label_caption = read_npy('COCO_multi_label_caption_selection_101_32000.npy', self.device)
                #self._multi_label_caption = read_npy('COCO_multi_label_caption_selection_101_v3.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
            else:
                self.caption = read_npy('COCO_caption_selection.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                self.caption_local = read_npy('COCO_caption_selection_local.npy', self.device)
                self.caption_local = self.caption_local / self.caption_local.norm(dim=-1, keepdim=True)

                
                self._multi_label_caption = read_npy('COCO_multi_label_caption_selection_50_32000.npy', self.device)
                #self._multi_label_caption = read_npy('COCO_multi_label_caption_selection_50_v3.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)

        elif DATASET == "NUSWIDE":
            if RESNET101:
                self.caption = read_npy('nus_llm_caption_selection_101_87500_one_cls.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                self._multi_label_caption = read_npy('nus_llm_multi_label_caption_selection_101_87500_one_cls.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
                #nus_multi_label_caption_selection_101_v3_7000
            else:
                """
                self.caption = read_npy('nus_llm_caption_selection_50_27_10000.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                self._multi_label_caption = read_npy('nus_llm_caption_selection_50_27_10000.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
                """
                self.caption = read_npy('nus_llm_caption_selection_50_57600_one_cls.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                #self._multi_label_caption = read_npy('nus_llm_multi_label_caption_selection_50_127500_one_cls.npy', self.device)
                self._multi_label_caption = read_npy('nus_llm_multi_label_caption_selection_50_57600_one_cls.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
                


        elif DATASET == "VOC":
            if RESNET101:
                self.caption = read_npy('VOC_caption_selection_100_101.npy', self.device)
                #self.caption = read_npy('VOC_caption_selection_min_101.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)

                self._multi_label_caption = read_npy('VOC_multi_label_caption_selection_101_v5_40000.npy', self.device)
                #self._multi_label_caption = read_npy('VOC_multi_label_caption_selection_101_v6_40000.npy', self.device) 
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
               # self._multi_label_caption = self._multi_label_caption.permute(1,0,2) 200 100 512
            else:
                self.caption = read_npy('VOC_caption_selection_100_50.npy', self.device)
                #self.caption = read_npy('VOC_caption_selection.npy', self.device)
                self.caption = self.caption / self.caption.norm(dim=-1, keepdim=True)
                
                self._multi_label_caption = read_npy('VOC_multi_label_caption_selection_50_v5_40000.npy', self.device)

                #self._multi_label_caption = read_npy('VOC_multi_label_caption_selection_50_v3.npy', self.device)
                self._multi_label_caption = self._multi_label_caption / self._multi_label_caption.norm(dim=-1,
                                                                                                       keepdim=True)
               # self._multi_label_caption = self._multi_label_caption.permute(1,0,2)#  .view(100,200,-1)
    def encode_image(self, x):
        def stem(x):
            for conv, bn in [(self.visual_encoder.conv1, self.visual_encoder.bn1), \
                             (self.visual_encoder.conv2, self.visual_encoder.bn2),
                             (self.visual_encoder.conv3, self.visual_encoder.bn3)]:
                x = self.visual_encoder.relu(bn(conv(x)))
            x = self.visual_encoder.avgpool(x)
            return x

        x = x.type(self.visual_encoder.conv1.weight.dtype)
        x = stem(x)
        x = self.visual_encoder.layer1(x)
        x = self.visual_encoder.layer2(x)
        x = self.visual_encoder.layer3(x)
        x = self.visual_encoder.layer4(x)
        return x

    def model_inference(self, image, label):
        image_feat = self.encode_image(image)
        b, c, h, w = image_feat.shape
        x = image_feat.reshape(b, c, h * w).permute(2, 0, 1)

        x = F.linear(x, self.v_linear_weight, self.v_linear_bias)
        x = F.linear(x, self.c_linear_weight, self.c_linear_bias)
        image_features = x

        image_feature_, _ = self.clip_model.visual.attnpool(image_feat)
        image_features = image_features / image_features.norm(dim=-1, keepdim=True)
        image_feature_ = image_feature_ / image_feature_.norm(dim=-1, keepdim=True)

        def get_global_p_three_step(caption, image_feature_,
                                    temp):  # caption: [10, 10, 70, 512], image_feature_: [100, 512]
            # Step 1: Calculate similarity for the 70 axis and apply softmax
            # Compute similarity across the 70 dimension
            similarity = temp * torch.einsum('ijkc,cb->ijkb', caption, image_feature_.t())  # [10,10, 70, 100]
            attention_weights = F.softmax(similarity, dim=2)  # [10,10, 70, 100] #k axis

            # Compute the weighted sum across the 70 dimension

            # torch.Size([10, 10, 70, 100]) torch.Size([10, 10, 70, 512])
            weighted_sum = torch.einsum('ijbk,ijkc->ijbc', attention_weights.permute(0, 1, 3, 2),
                                        caption)  # [10,10,100,512]

            # Step 2: Calculate similarity for the new axis (100) and apply softmax
            # Compute similarity across the 100 dimension
            # torch.Size([10, 10, 100, 512])
            weighted_sum = weighted_sum.permute(2, 0, 1, 3)  # [100,10,10,512]
            # [100,10,10,512]
            similarity_2 = temp * torch.einsum('bijc,bc->bij', weighted_sum, image_feature_)  # [100,10,10]
            attention_weights_2 = F.softmax(similarity_2, dim=2)  # [100,10,10] #j axis
            # torch.Size([100, 10, 10]) torch.Size([100, 10, 10, 512])
            weighted_sum_2 = torch.einsum('bij,bijc->bic', attention_weights_2, weighted_sum)  # [100,10,512]

            # Step 3: Calculate similarity for the first axis (10) and apply softmax
            # Compute similarity across the 10 dimension (batch dimension)
            similarity_3 = temp * torch.einsum('bic,bc->bi', weighted_sum_2, image_feature_)  # [100,10]
            attention_weights_3 = F.softmax(similarity_3, dim=1)  # [100, 10]

            # Compute the final weighted sum across the 10 dimension
            # [100,10] #[100,10,512]
            global_p = torch.einsum('bi,bic->bc', attention_weights_3, weighted_sum_2)  # [100,512]

            return global_p

        # set ideal dimension and reshape!!
        
        if TASK_ADAPT_GLOBAL:
        
            #print(self._multi_label_caption.shape)
            dim1, dim2, depth = self._multi_label_caption.shape
            multi_label_caption = self._multi_label_caption.reshape(-1,depth)
            print (multi_label_caption.shape)
            

            if DATASET=='VOC':
                if VOC_CUT :
                    multi_label_caption = multi_label_caption[:VOC_CUT]
                    TEMP1 = 55
                    TEMP2 = 30
                    CLS_GLO_TEMP = 1/100
                    CLS_LOC_TEMP = 1/100
                    if multi_label_caption.shape[0] == 1000:
                        dim1_1=10
                        dim2 =10
                    elif multi_label_caption.shape[0] == 2000:
                        dim1_1=10
                        dim2 =20
                    elif multi_label_caption.shape[0] == 4000:
                        dim1_1=20
                        dim2 =10
                    elif multi_label_caption.shape[0] == 8000:
                        dim1_1=20
                        dim2 =20
                    elif multi_label_caption.shape[0] == 16000:
                        dim1_1=20
                        dim2 =40
                    elif multi_label_caption.shape[0] == 32000:
                        dim1_1=40
                        dim2 =20                    
                else:
                    dim1_1 =40
                    dim2 =25
                    TEMP1 = 55
                    TEMP2 = 30
                    CLS_GLO_TEMP = 1/100
                    CLS_LOC_TEMP = 1/100
                    
            elif DATASET=='NUSWIDE':
                #dim1_1 = 50
                #dim2 = 51
                dim1_1 = 40
                dim2 = 36
                TEMP1 = 40
                TEMP2 = 10
                #CLS_GLO_TEMP = 1
                #CLS_LOC_TEMP = 5
                CLS_GLO_TEMP = 1/100
                CLS_LOC_TEMP = 1/100
            elif DATASET=='COCO':
                #multi_label_caption = self._multi_label_caption.reshape(-1,depth)
                multi_label_caption = multi_label_caption[:COCO_CUT]
                
                TEMP1 = 80
                TEMP2 = 40
                CLS_GLO_TEMP = 1
                CLS_LOC_TEMP = 5
                
                if multi_label_caption.shape[0] == 1000:
                    dim1_1=10
                    dim2 =10
                elif multi_label_caption.shape[0] == 2000:
                    dim1_1=10
                    dim2 =20
                elif multi_label_caption.shape[0] == 4000:
                    dim1_1=20
                    dim2 =10
                elif multi_label_caption.shape[0] == 8000:
                    dim1_1=20
                    dim2 =20
                elif multi_label_caption.shape[0] == 16000:
                    dim1_1=20
                    dim2 =40
                elif multi_label_caption.shape[0] == 32000:
                    dim1_1=40
                    dim2 =20
                

            multi_step_input = multi_label_caption.reshape(dim1_1, dim1_1, dim2, depth)
            global_p = get_global_p_three_step(multi_step_input, image_feature_, TEMP1)

            #  image_feature_ = global_p

            image_feature_temp = global_p  # (0.5*image_feature_ + 0.5* global_p) / 1.0
            
        else:
            
            if DATASET=='VOC':
                CLS_GLO_TEMP = 1/100
                CLS_LOC_TEMP = 1/100
            elif DATASET=='NUSWIDE':
                CLS_GLO_TEMP = 1/100
                CLS_LOC_TEMP = 1/100
            elif DATASET=='COCO':
                CLS_GLO_TEMP = 1
                CLS_LOC_TEMP = 5
            
            image_feature_temp = image_feature_
        
        logit_scale = self.clip_model.logit_scale.exp()  # logit_scale = self.clip_model.logit_scale.exp()
        
        
        ####global start #######
            
        if CLASS_ADAPT_GLOBAL:
            A = torch.matmul(self.caption, image_feature_temp.t())  # 80 16 100
            A_up = F.softmax(A*CLS_GLO_TEMP, dim=1) # origin 
            #A_up = F.softmax(A/100, dim=1) # edit for voc
            
            P_up = torch.matmul(A_up.permute(0, 2, 1), self.caption)  # 80 100 512
            logits_ = logit_scale * (torch.sum(P_up * image_feature_temp.unsqueeze(0), dim=2).permute(1,0) + image_feature_ @ self.text_features.t()) / 2.0 #origin 
        else:
            logits_ = logit_scale * image_feature_ @ self.text_features.t() #origin 
            
            
        ####global end #######
        
        ####local start#######

        if TASK_ADAPT_LOCAL:
            grid_max = image_feat.shape[-1]

            local_logit_list = []

            for row in range(grid_max):
                for col in range(grid_max):
                    local_patch = image_features[row * grid_max + col]
                    updated_img_feat = get_global_p_three_step(multi_step_input, local_patch, TEMP2)
                    # [80,16,512] [100,512]

                    A = self.caption @ updated_img_feat.t()  # [80,16,100]
                    A_up = F.softmax(A *CLS_LOC_TEMP, dim=1)  # [80,16,100] # origin

                    caption_logit_ = self.caption @ updated_img_feat.t()  # [80,16,512] [512,100] =>[80,16,100]
                    patch_logit = logit_scale * torch.sum(A_up * caption_logit_, dim=1)
                    # [80,16,100] *[80,16,100]
                    local_logit_list.append(patch_logit)

            local_logit_list = torch.stack(local_logit_list, dim=0)  # [196,80,100]
            
            logits = (local_logit_list.permute(0, 2, 1) + logit_scale * image_features @ self.text_features.t()) / 2.0  #origin 
        
        else:
            
            if CLASS_ADAPT_LOCAL:
                caption_logit_ = torch.einsum('hbd,dcn->hbcn', self.caption, image_features.permute(2, 0, 1))
                caption_logit_ = caption_logit_.permute(2, 3, 0, 1)

                A_ = caption_logit_  # torch.matmul(self.caption, image_feature_.t()) #80 16 100
                A_up_ = F.softmax(A_ * 5, dim=3)

                logits = logit_scale * (
                        torch.sum(A_up_ * caption_logit_, dim=3) + image_features @ self.text_features.t()) / 2.0
            else:
                logits = logit_scale *image_features @ self.text_features.t()
        
        

        a = (label[0, :] == 1).nonzero(as_tuple=False)
        
        
        
        
        patch_output = logits.clone()
        
        
        ####local end #######
        
        #### WTA #########

        # Original local logits [14X14,100,80]
        if WTA == False:
            prob_spatial = torch.nn.functional.softmax(logits, dim=0) 
            logits = torch.sum(logits * prob_spatial, dim=0)

        else:
            # WTA
            grid_size = int(math.sqrt(logits.shape[0]))
            bs = logits.shape[1]
            num_classes = logits.shape[2]
            wta_result = torch.zeros((grid_size * grid_size, bs, num_classes), device=logits.device)  # 모든 값을 0으로 초기화
            local_logits = logits.reshape(grid_size, grid_size, bs, num_classes)  # [[14,14,100,80]

            # Flatten the first two dimensions of local_logits so that we can work with each patch individually
            # Now each patch is a separate element in the zeroth dimension
            flat_logits = local_logits.view(-1, *local_logits.shape[-2:])  # Shape [196, 100, 80]

            # Find the max values in each patch
            max_values, _ = flat_logits.max(dim=-1, keepdim=True)  # Shape [196, 100, 1]

            # Use torch.where to keep max values and set others to -1
            wta_result = torch.where(flat_logits == max_values, flat_logits, torch.full_like(flat_logits, -1.0))

            ## strong WTA

            result = wta_result.permute(1, 0, 2)  # [100, 196 ,80]

            # Create a mask for values that are not -1
            mask = result != -1

            # Use the mask to replace all -1 with the minimum float value
            # because -1 could be a valid maximum when dealing with negative values
            result_masked = torch.where(mask, result, torch.full_like(result, float('-inf')))

            # Now, instead of looping, use torch.max to find the maximum value across the grid
            # This will ignore the -inf values and effectively find the maximum non--1 value
            strong_wta, _ = torch.max(result_masked, dim=1)  # [100, 80]

            # Replace the -inf back to -1 if there was no valid maximum found
            strong_wta[strong_wta == float('-inf')] = -1.0

            # 결과를 logits에 저장
            logits = strong_wta
            
        #### WTA end #########

        return logits_, logits, None, None, patch_output

    @torch.no_grad()
    def test(self, split=None):
        """A generic testing pipeline."""
        self.set_model_mode("eval")
        self.evaluator.reset()

        if split is None:
            split = self.cfg.TEST.SPLIT

        if split == "val" and self.val_loader is not None:
            data_loader = self.val_loader
            print("Do evaluation on {} set".format(split))
        else:
            data_loader = self.test_loader
            print("Do evaluation on test set")
            
            
        time_queue = []
        warmup_phase = 100

        for batch_idx, batch in enumerate(tqdm(data_loader)):
            input, label = self.parse_batch_test(batch)
            # output = self.model_inference(input)

            if MEASURE_TIME:
                st = time.time()

            output, output_pos, image_features_, text_features_, patch_output = self.model_inference(input, label)
            
            if VISUALIZE:
                for idx in range(output.shape[0]):
                    save_attmap(batch_idx,idx,input[idx],patch_output[:,idx],label[idx], (output+output_pos/2)[idx])

            if MEASURE_TIME:
                ed = time.time()
                elapsed  = ed - st
                if batch_idx > warmup_phase:
                    time_queue.append(elapsed)
                    print (np.mean(time_queue))
                

            self.evaluator.process(output, label, output_pos)

        if UNSEEN:
            if FEWSHOT:
                results = self.evaluator.evaluate_zsl(3,False,True)        
            else:
                if GZSL:
                    results = self.evaluator.evaluate_zsl(3,True,False)
                else:
                    results = self.evaluator.evaluate_zsl(3,False,False)
        else:
            results = self.evaluator.evaluate()      
                
        for k, v in results.items():
            tag = "{}/{}".format(split, k)
            self.write_scalar(tag, v, self.epoch)

        return list(results.values())[0]


@TRAINER_REGISTRY.register()
class ZeroshotCLIP2(ZeroshotCLIP):
    """Prompt ensembling."""

    # templates = IMAGENET_TEMPLATES
    templates = IMAGENET_TEMPLATES_SELECT

    def build_model(self):
        cfg = self.cfg
        classnames = self.dm.dataset.classnames

        print(f"Loading CLIP (backbone: {cfg.MODEL.BACKBONE.NAME})")
        clip_model = load_clip_to_cpu(cfg)
        clip_model.to(self.device)

        for params in clip_model.parameters():
            params.requires_grad_(False)

        # add custom-made prompt
        if cfg.DATASET.NAME != "ImageNet":
            self.templates += [CUSTOM_TEMPLATES[cfg.DATASET.NAME]]

        num_temp = len(self.templates)
        print(f"Prompt ensembling (n={num_temp})")

        mean_text_features = 0
        for i, temp in enumerate(self.templates):
            prompts = [temp.format(c.replace("_", " ")) for c in classnames]
            prompts = torch.cat([clip.tokenize(p) for p in prompts]).to(self.device)
            text_features = clip_model.encode_text(prompts)
            text_features = text_features / text_features.norm(dim=-1, keepdim=True)
            mean_text_features = mean_text_features + text_features
        mean_text_features = mean_text_features / num_temp
        mean_text_features = mean_text_features / mean_text_features.norm(dim=-1, keepdim=True)

        self.text_features = mean_text_features
        self.clip_model = clip_model
