import os
os.environ['CUDA_VISIBLE_DEVICES'] = '4'
import torch
print(torch.cuda.is_available())
from ExplanationEvaluation.configs.selector import Selector
from ExplanationEvaluation.tasks.replication_table import experiment_new_fid_ratio_editdistance,replication_sp


datasets = [ 'treecycles', 'treegrids', 'ba2motifs', 'mutag']  
for _dataset in datasets:
    #_dataset = 'treecycles'      
    _explainer = 'pgexplainer' 

    _folder = 'replication' # One of: replication, extension

    # PGExplainer
    config_path = f"./ExplanationEvaluation/configs/{_folder}/explainers/{_explainer}/{_dataset}.json"
    print(config_path)
    config = Selector(config_path)


    extension = (_folder == 'extension')

    # use gin model 
    # config.args.explainer.model = 'PGIN'  
    experiment_new_fid_ratio_editdistance(config.args.explainer, k_p=0.1, k_m=0.1, seeds_num=1)


