# SELFI: Selective Fusion of Identity for Generalizable Deepfake Detection

[![License: CC BY-NC 4.0](https://img.shields.io/badge/License-CC_BY--NC_4.0-brightgreen.svg)](https://creativecommons.org/licenses/by-nc/4.0/) ![Release .10](https://img.shields.io/badge/Release-1.0-brightgreen) ![PyTorch](https://img.shields.io/badge/PyTorch-1.11-brightgreen) ![Python](https://img.shields.io/badge/Python-3.7.2-brightgreen)


[[paper]TODO] [[pre-trained weights]TODO]

## 🔧 Setup Instructions

### 1. Install and Set Up DeepfakeBench

We rely on <a href='https://github.com/SCLBD/DeepfakeBench'>DeepfakeBench</a> for dataset handling and baseline detector structure. Follow the instructions below:

```bash
git clone https://github.com/SCLBD/DeepfakeBench.git
cd DeepfakeBench
```

Then complete the following steps as described in the DeepfakeBench README:
  - Download the datasets
  - Generate the required JSON annotation files
  - Set up the Python environment (e.g., using conda or pip)

> ⚠️ Note: Make sure the datasets are stored in the correct directory structure expected by DeepfakeBench.


### 2. Download Face Recognition Model Weights
Our method requires a pretrained face recognition model for identity feature extraction. Please download the weights from the following link: <a href='https://huggingface.co/lithiumice/arcface_torch/blob/5aac4346938ae100f5145f549c4540d8bf7feb6c/ms1mv3_arcface_r100_fp16.pth'>ArcFace IResNet100 pretrained model (ms1mv3_arcface_r100_fp16.pth)</a>

Place the downloaded file in the following directory:
```bash
./training/pretrained/ms1mv3_arcface_r100_fp16.pth
```

### 3. How to Run
To train SELFI:
```bash
python training/train.py \
  --detector_path ./training/config/detector/selfi.yaml \
  --train_dataset "FaceForensics++" \
  --test_dataset "Celeb-DF-v2" "DeepFakeDetection" "DFDC" "DFDCP"
```

To train SELFI (with ddp)
```bash
python3 -m torch.distributed.launch --nproc_per_node=5 training/train.py \
  --detector_path ./training/config/detector/selfi.yaml \
  --train_dataset "FaceForensics++" \
  --test_dataset "Celeb-DF-v2" "DeepFakeDetection" "DFDC" "DFDCP" \
  --ddp
```

To test SELFI:
```bash
python training/test.py \
  --detector_path ./training/config/detector/selfi.yaml \
  --test_data "FaceForensics++" "Celeb-DF-v1" "Celeb-DF-v2" "DeepFakeDetection" "DFDC" "DFDCP" "FaceShifter" \
  --weights_path path_to_avg_best
```

