#!/bin/bash
export PYTHONPATH="./src:$PYTHONPATH"


PROMPT_TEMPLATE="nl" # Options: "ascii", "nl"
MODEL_NAME="meta-llama/Meta-Llama-3-8B"
SEED=42

#source activate llama_recipes # Replace `llama_recipes` with the name of the environment installed with `requirements_ft.txt`

python -m torch.distributed.launch \
  --nnodes 1 \
  --nproc_per_node 2 \
  src/xlogominiprog/finetuning.py \
  --dataset "custom_dataset" \
  --custom_dataset.file "./src/xlogominiprog/custom_dataset.py" \
  --custom_dataset.prompt_template ${PROMPT_TEMPLATE} \
  --model_name ${MODEL_NAME} \
  --use_peft \
  --peft_method lora \
  --enable_fsdp \
  --fsdp_config.pure_bf16 \
  --output_dir "./results/checkpoints/${PROMPT_TEMPLATE}/Meta-Llama-3-8B/" \
  --use_fast_kernels \
  --train_config.num_epochs 2 \
  --lora_config.r 32 \
  --lora_config.lora_alpha 128 \
  --train_config.batching_strategy "padding" \
  --train_config.seed ${SEED}