#!/bin/bash

export PYTHONPATH="./src:$PYTHONPATH"

source activate vllmenv # Activate the environment with vLLM installed

PEFT_MODEL="./results/checkpoints/nl/Meta-Llama-3-8B" # The folder to the fine-tuned model checkpoint
MODEL_NAME="meta-llama/Meta-Llama-3-8B"

epochs=(1 2 3)                                              # The epochs to evaluate
EVAL_DATASET_PATH="./data/xlogomini-dataset-test-real.json" # The path to the evaluation dataset

for epoch in "${epochs[@]}"; do
  CHECKPOINT="${PEFT_MODEL}/epoch_$epoch"
  echo "Inference checkpoint: $CHECKPOINT"

  python src/xlogominiprog/inference_ft_vllm.py \
    --model_name "${MODEL_NAME}" \
    --peft_model "${CHECKPOINT}" \
    --top_p 1 \
    --temperature 0 \
    --dataset_path "${EVAL_DATASET_PATH}"
done
