PROMPT_TEMPLATE_ASCII = """You are presented with a visual programming task involving a goal, a grid, a turtle, various items (or lines). You need to write Python code that enables the turtle to accomplish the goal within the grid.

#### Grid and Turtle
A task's grid contain a turtle and some items. The turtle can face one of four directions: North (`^`), South (`v`), East (`>`), or West (`<`). An item has three attributes: `count`, `color`, and `name`. The `count` indicates the number of identical items in that grid cell. The `color` specifies the item's color, and the `name` describes the item's type. Here are the possible options:
- Colors: Red (`R`), Green (`G`), Blue (`B`), Yellow (`Y`), Black (`K`), White (`W`), Orange (`O`), Purple (`U`), Pink (`P`)
- Names: Circle (`o`), Rectangle (`□`), Triangle (`△`) ,Cross (`X`), Strawberry (`S`), Lemon (`L`)
- Counts: `1`, `2`, `3`, `4`
- For example, `2RS` means two red strawberries.

We use the following symbols to describe a grid:
- `---` represents the top or bottom edge of a grid cell.
- `|` represents the left or right edge of a grid cell.
- `===` represents an upper or lower wall of a cell. 
- `‖` represents a left or right wall of a cell.
- `+` represents the corner of a grid cell.
- `X` represents a forbidden cell that cannot be accessed.

#### Grid Cell Properties
- A grid cell may be `accessible` or `forbidden`. The turtle can move to an accessible cell but not into a forbidden cell. If the turtle tries to move into a forbidden cell, it will crash and fail to solve the task.
- Grid cells can have walls on their edges (top, bottom, left, and right). The turtle cannot move through walls, otherwise it will crash and fail to solve the task.

#### Available Python Functions
To solve the task, you can use the following Python functions:
- `move_forward()`: This function moves the turtle forward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing north, after executing `move_forward()`, the turtle will be at the position (x, y-1).
- `move_backward()`: This function moves the turtle backward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing west, after executing `move_backward()`, the turtle will be at the position (x+1, y).
- `turn_left()`: This function makes the turtle turn left in the direction it is facing - by 90 degrees. For example, if the turtle is facing north, after executing `turn_left()`, the turtle will be facing west.
- `turn_right()`: This function makes the turtle turn right in the direction it is facing - by 90 degrees. For example, if the turtle is facing south, after executing `turn_right()`, the turtle will be facing west.
- `setpc(color)`: This function sets the pen color to the specified color. The available colors are: red, green, blue, yellow, black, white. The default pen color is black. The trajectory of the turtle is drawn with the pen color.
- `for` loop: This loop is used to repeat a set of commands a specified number of times. For example, `for i in range(4):` will repeat the commands inside the loop 4 times.

{instruction}

### Task:
{task}

### Goal:
{description}

### {condition}:
"""

PROMPT_TEMPLATE_NL = """You are presented with a visual programming task involving a goal, a grid, a turtle, various items (or lines). Your need to write Python code that enables the turtle to accomplish the goal within the grid.

#### Grid and Turtle
- The task has a `m x n` grid. The coordinates of the grid cells are `(x, y)`, where `x` is the column number and `y` is the row number. The top-left cell has coordinates `(0, 0)`.
- The turtle starts at a specific grid cell and faces one of four directions: North, East, South, or West.

#### Items
Each item in the grid is defined by three attributes:
- `count`: The number of identical items in that grid cell.
- `color`: The item's color. Options include red, green, blue, yellow, black, white, orange, purple, and pink.
- `name`: The type of the item, such as circle, rectangle, triangle, cross, strawberry, or lemon.

#### Lines
Sometimes, the grid doesn't contain any items but has lines with colors. You need to draw lines of the specified color to solve the task.

#### Grid Cell Properties
- A grid cell may be `accessible` or `forbidden`. The turtle can move to an accessible cell but not into a forbidden cell. If the turtle tries to move into a forbidden cell, it will crash and fail to solve the task.
- Grid cells can have walls on their edges (top, bottom, left, and right). The turtle cannot move through walls, otherwise it will crash and fail to solve the task.

#### Available Python Functions
To solve the task, you can use the following Python functions:
- `move_forward()`: This function moves the turtle forward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing north, after executing `move_forward()`, the turtle will be at the position (x, y-1).  
- `move_backward()`: This function moves the turtle backward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing west, after executing `move_backward()`, the turtle will be at the position (x+1, y).  
- `turn_left()`: This function makes the turtle turn left in the direction it is facing - by 90 degrees. For example, if the turtle is facing north, after executing `turn_left()`, the turtle will be facing west.  
- `turn_right()`: This function makes the turtle turn right in the direction it is facing - by 90 degrees. For example, if the turtle is facing south, after executing `turn_right()`, the turtle will be facing west.  
- `setpc(color)`: This function sets the pen color to the specified color. The available colors are: red, green, blue, yellow, black, white. The default pen color is black. The trajectory of the turtle is drawn with the pen color.  
- `for` loop: This loop is used to repeat a set of commands a specified number of times. For example, `for i in range(4):` will repeat the commands inside the loop 4 times.  

{instruction}

### Task:
{task}

### Goal:
{description}

### {condition}:
"""

COND_POSITIVE = "CORRECT "
COND_NEGATIVE = "BUGGY "
INSTR_POSITIVE = "Now, write a CORRECT Python code that successfully solves the following task"
INSTR_NEGATIVE = "Now, write a BUGGY Python code that fails to solve the following task"

# for enhanced-emulator
COND_CORRECT = "CORRECT code that fully meets all task requirements and code constraints"
COND_WRONG= "BUGGY code that fails to solve the task"
COND_BUGGY_FORMAT_WRONG = "BUGGY code that deviates from the required code format"
COND_BUGGY_CRASH_INTO_WALL = "BUGGY code that crashes into a wall at the position ({x}, {y})"
COND_BUGGY_CRASH_FORBIDDEN_CELL = "BUGGY code that crashes into a forbidden cell at the position ({x}, {y})"
COND_BUGGY_OUT_OF_GRID = "BUGGY code that moves the turtle out of the grid boundaries"
COND_BUGGY_CODE_CONSTRAINTS = "BUGGY code that fails to adhere to specified code constraints, yet does not crash"
COND_BUGGY_GOAL_FAIL = "BUGGY code that fails to achieve the specified goal, yet does not crash"
COND_BUGGY_GOAL_AND_CONSTRAINTS = "BUGGY code that neither achieves the specified goal nor adheres to code constraints, yet does not crash"

INSTR_CORRECT = f"Now, write a {COND_CORRECT}."
INSTR_WRONG = f"Now, write a {COND_WRONG}."
INSTR_BUGGY_FORMAT_WRONG = f"Now, write a {COND_BUGGY_FORMAT_WRONG}."
INSTR_BUGGY_CRASH_INTO_WALL = f"Now, write a {COND_BUGGY_CRASH_INTO_WALL}."
INSTR_BUGGY_CRASH_FORBIDDEN_CELL = f"Now, write a {COND_BUGGY_CRASH_FORBIDDEN_CELL}."
INSTR_BUGGY_OUT_OF_GRID = f"Now, write a {COND_BUGGY_OUT_OF_GRID}."
INSTR_BUGGY_CODE_CONSTRAINTS = f"Now, write a {COND_BUGGY_CODE_CONSTRAINTS}."
INSTR_BUGGY_GOAL_FAIL = f"Now, write a {COND_BUGGY_GOAL_FAIL}."
INSTR_BUGGY_GOAL_AND_CONSTRAINTS = f"Now, write a {COND_BUGGY_GOAL_AND_CONSTRAINTS}."

PROMPT_TEMPLATE_ASCII_BASE_MODEL = """You are presented with a visual programming task involving a goal, a grid, a turtle, various items (or lines). You need to write Python code that enables the turtle to accomplish the goal within the grid. 

#### Grid and Turtle
A task's grid contain a turtle and some items. The turtle can face one of four directions: North (`^`), South (`v`), East (`>`), or West (`<`). An item has three attributes: `count`, `color`, and `name`. The `count` indicates the number of identical items in that grid cell. The `color` specifies the item's color, and the `name` describes the item's type. Here are the possible options:
- Colors: Red (`R`), Green (`G`), Blue (`B`), Yellow (`Y`), Black (`K`), White (`W`), Orange (`O`), Purple (`U`), Pink (`P`)
- Names: Circle (`o`), Rectangle (`□`), Triangle (`△`) ,Cross (`X`), Strawberry (`S`), Lemon (`L`)
- Counts: `1`, `2`, `3`, `4`
- For example, `2RS` means two red strawberries.

We use the following symbols to describe a grid:
- `---` represents the top or bottom edge of a grid cell.
- `|` represents the left or right edge of a grid cell.
- `===` represents an upper or lower wall of a cell. 
- `‖` represents a left or right wall of a cell.
- `+` represents the corner of a grid cell.
- `X` represents a forbidden cell that cannot be accessed.

#### Grid Cell Properties
- A grid cell may be `accessible` or `forbidden`. The turtle can move to an accessible cell but not into a forbidden cell. If the turtle tries to move into a forbidden cell, it will crash and fail to solve the task.
- Grid cells can have walls on their edges (top, bottom, left, and right). The turtle cannot move through walls, otherwise it will crash and fail to solve the task.

#### Available Python Functions
To solve the task, you can use the following Python functions:
- `move_forward()`: This function moves the turtle forward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing north, after executing `move_forward()`, the turtle will be at the position (x, y-1).  
- `move_backward()`: This function moves the turtle backward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing west, after executing `move_backward()`, the turtle will be at the position (x+1, y).  
- `turn_left()`: This function makes the turtle turn left in the direction it is facing - by 90 degrees. For example, if the turtle is facing north, after executing `turn_left()`, the turtle will be facing west.  
- `turn_right()`: This function makes the turtle turn right in the direction it is facing - by 90 degrees. For example, if the turtle is facing south, after executing `turn_right()`, the turtle will be facing west.  
- `setpc(color)`: This function sets the pen color to the specified color. The available colors are: red, green, blue, yellow, black, white. The default pen color is black. The trajectory of the turtle is drawn with the pen color.  
- `for` loop: This loop is used to repeat a set of commands a specified number of times. For example, `for i in range(4):` will repeat the commands inside the loop 4 times.  

Your code should follow the format:
```python
def run():
    # Your solution code goes here
    pass
```

Here are some examples of the code:

Example 1:
```python
def run():
    move_forward()
    for i in range(4):
        move_forward()
        turn_left()
```

Example 2:
```python
def run():
    move_forward()
    setpc('red')
    for i in range(3):
        move_forward()
    turn_right()
    move_backward()
```

Now, write a CORRECT Python code that successfully solves the following task:

### Task:
{task}

### Goal:
{description}

### CORRECT Code:
"""

PROMPT_TEMPLATE_NL_BASE_MODEL = """You are presented with a visual programming task involving a goal, a grid, a turtle, various items (or lines). Your need to write Python code that enables the turtle to accomplish the goal within the grid.

#### Grid and Turtle
- The task has a `m x n` grid. The coordinates of the grid cells are `(x, y)`, where `x` is the column number and `y` is the row number. The top-left cell has coordinates `(0, 0)`.
- The turtle starts at a specific grid cell and faces one of four directions: North, East, South, or West.

#### Items
Each item in the grid is defined by three attributes:
- `count`: The number of identical items in that grid cell.
- `color`: The item's color. Options include red, green, blue, yellow, black, white, orange, purple, and pink.
- `name`: The type of the item, such as circle, rectangle, triangle, cross, strawberry, or lemon.

#### Lines
Sometimes, the grid doesn't contain any items but has lines with colors. You need to draw lines of the specified color to solve the task.

#### Grid Cell Properties
- A grid cell may be `accessible` or `forbidden`. The turtle can move to an accessible cell but not into a forbidden cell. If the turtle tries to move into a forbidden cell, it will crash and fail to solve the task.
- Grid cells can have walls on their edges (top, bottom, left, and right). The turtle cannot move through walls, otherwise it will crash and fail to solve the task.

#### Available Python Functions
To solve the task, you can use the following Python functions:
- `move_forward()`: This function moves the turtle forward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing north, after executing `move_forward()`, the turtle will be at the position (x, y-1).  
- `move_backward()`: This function moves the turtle backward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing west, after executing `move_backward()`, the turtle will be at the position (x+1, y).  
- `turn_left()`: This function makes the turtle turn left in the direction it is facing - by 90 degrees. For example, if the turtle is facing north, after executing `turn_left()`, the turtle will be facing west.  
- `turn_right()`: This function makes the turtle turn right in the direction it is facing - by 90 degrees. For example, if the turtle is facing south, after executing `turn_right()`, the turtle will be facing west.  
- `setpc(color)`: This function sets the pen color to the specified color. The available colors are: red, green, blue, yellow, black, white. The default pen color is black. The trajectory of the turtle is drawn with the pen color.  
- `for` loop: This loop is used to repeat a set of commands a specified number of times. For example, `for i in range(4):` will repeat the commands inside the loop 4 times.  

Your code should follow the format:
```python
def run():
    # Your solution code goes here
    pass
```

Here are some examples of the code:

Example 1:
```python
def run():
    move_forward()
    for i in range(4):
        move_forward()
        turn_left()
```

Example 2:
```python
def run():
    move_forward()
    setpc('red')
    for i in range(3):
        move_forward()
    turn_right()
    move_backward()
```

Now, write a CORRECT Python code that successfully solves the following task:

### Task:
{task}

### Goal:
{description}

### CORRECT Code:
"""

PROMPT_TEMPLATE_NL_BASE_MODEL_VISION = """You are presented with a visual programming task involving a goal, a grid, a turtle, various items (or lines). An image is provided as a visual guide. Your need to write Python code that enables the turtle to accomplish the goal within the grid, taking into account the information from the image.

#### Grid and Turtle
- The task has a `m x n` grid. The coordinates of the grid cells are `(x, y)`, where `x` is the column number and `y` is the row number. The top-left cell has coordinates `(0, 0)`.
- The turtle starts at a specific grid cell and faces one of four directions: North, East, South, or West.

#### Items
Each item in the grid is defined by three attributes:
- `count`: The number of identical items in that grid cell.
- `color`: The item's color. Options include red, green, blue, yellow, black, white, orange, purple, and pink.
- `name`: The type of the item, such as circle, rectangle, triangle, cross, strawberry, or lemon.

#### Lines
Sometimes, the grid doesn't contain any items but has lines with colors. You need to draw lines of the specified color to solve the task.

#### Grid Cell Properties
- A grid cell may be `accessible` or `forbidden`. The turtle can move to an accessible cell but not into a forbidden cell. If the turtle tries to move into a forbidden cell, it will crash and fail to solve the task.
- Grid cells can have walls on their edges (top, bottom, left, and right). The turtle cannot move through walls, otherwise it will crash and fail to solve the task.

#### Available Python Functions
To solve the task, you can use the following Python functions:
- `move_forward()`: This function moves the turtle forward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing north, after executing `move_forward()`, the turtle will be at the position (x, y-1).  
- `move_backward()`: This function moves the turtle backward in the direction it is facing by one grid cell. For example, if the turtle is at the position (x, y) and facing west, after executing `move_backward()`, the turtle will be at the position (x+1, y).  
- `turn_left()`: This function makes the turtle turn left in the direction it is facing - by 90 degrees. For example, if the turtle is facing north, after executing `turn_left()`, the turtle will be facing west.  
- `turn_right()`: This function makes the turtle turn right in the direction it is facing - by 90 degrees. For example, if the turtle is facing south, after executing `turn_right()`, the turtle will be facing west.  
- `setpc(color)`: This function sets the pen color to the specified color. The available colors are: red, green, blue, yellow, black, white. The default pen color is black. The trajectory of the turtle is drawn with the pen color.  
- `for` loop: This loop is used to repeat a set of commands a specified number of times. For example, `for i in range(4):` will repeat the commands inside the loop 4 times.  

Your code should follow the format:
```python
def run():
    # Your solution code goes here
    pass
```

Here are some examples of the code:

Example 1:
```python
def run():
    move_forward()
    for i in range(4):
        move_forward()
        turn_left()
```

Example 2:
```python
def run():
    move_forward()
    setpc('red')
    for i in range(3):
        move_forward()
    turn_right()
    move_backward()
```

Now, write a CORRECT Python code that successfully solves the following task:

### Task:
{task}

### Goal:
{description}

### CORRECT Code:
"""