def remove_nulls_from_json(value):
    """
    Recursively remove all None values from dictionaries, lists, and nested structures.
    """
    if isinstance(value, dict):
        return {k: remove_nulls_from_json(v) for k, v in value.items() if v is not None}
    elif isinstance(value, list):
        return [remove_nulls_from_json(v) for v in value if v is not None]
    else:
        return value