#!/bin/bash
#SBATCH --job-name              run_nait
#SBATCH --time                  24:00:00
#SBATCH --cpus-per-task         8
#SBATCH --gres                  gpu:a100:2
#SBATCH --mem                   80G
#SBATCH --output                ./logs/run_nait/%j.out
#SBATCH --error                 ./logs/run_nait/%j.err

set -e

model_name_or_path=$1
dataset_path=$2
reference_ds=$3
target_ds=$4
batch_size=$5
save_dir=$6
na_label=$7

echo "----------------------------"
echo "Job Name: ${job_name:-run_nait}"  # 输出作业名称
echo "Model Name or Path: $model_name_or_path"
echo "Dataset Path: $dataset_path"
echo "Reference Dataset: $reference_ds"
echo "Target Dataset: $target_ds"
echo "Batch Size: $batch_size"
echo "Save Directory: $save_dir"
echo "NA Label: $na_label"
echo "----------------------------"

python NAIT.py \
    --model_name_or_path $model_name_or_path \
    --dataset_path $dataset_path \
    --reference_ds $reference_ds \
    --target_ds $target_ds \
    --batch_size $batch_size \
    --save_dir $save_dir \
    --na_label $na_label