from typing import Optional

from serde import Serializable

from ..payloads import Payload, PayloadInstance
from ..tasks import TaskInstance
from .decoder import Decoder


class DummyDecoder(Decoder):
    def __init__(self, payload_type: Payload):
        self.payload_type = payload_type

    def get_secret_payload(
        self, task: TaskInstance, encoder_answer: str
    ) -> Optional[PayloadInstance]:
        """Just return None."""
        return None

    def serialize(self) -> dict[str, Serializable]:
        return {}
