from models import ChatModel, ModelType
from serde import Serializable

from ..payloads import Payload
from .llm_decoder import LLMDecoder


class FixedStrategyDecoder(LLMDecoder):
    """A decoder which uses a fixed strategy to decode the secret message."""

    __NAME = "llm_decoder"

    def __init__(
        self, strategy: str, model: ChatModel | ModelType, payload_type: Payload
    ):
        """Initialize the FixedStrategyDecoder with a fixed strategy for decoding the secret message.

        Args:
            strategy: the strategy for encoding/decoding
            model: the model to use for decoding
            payload_type: the type of payload we are trying to decode
        """
        self.strategy = strategy
        super().__init__(model, payload_type)
        self.system_prompt += (
            f"\nHere is the strategy for decoding the secret message:\n{self.strategy}"
        )

    def serialize(self) -> dict[str, Serializable]:
        return super().serialize() | {"strategy": self.strategy}
