from abc import abstractmethod

from serde import Serializable

from ..tasks import TaskInstance


class HonestModel:
    @abstractmethod
    def get_message(self, task: TaskInstance) -> str:
        """Get the message given the task.

        Args:
            task: a task instance e.g. answer question x

        Returns:
            the model's response to the task
        """
        pass

    def serialize(self) -> dict[str, Serializable]:
        return {}
