from abc import abstractmethod
from typing import Optional

from serde import Serializable

from ..tasks import TaskInstance


class Paraphraser:
    @abstractmethod
    def paraphrase(self, text: str, task: TaskInstance) -> Optional[str]:
        """Paraphrase a message from the encoder.

        Args:
            text: the encoder's message

        Returns:
            the paraphrased message
        """
        pass

    def serialize(self) -> dict[str, Serializable]:
        return {}
