import random
from math import ceil

from logger import logger


def get_balanced_integer_set(min_: int, max_: int, n: int) -> list[int]:
    """Get a balanced set of integers between min and max inclusive.

    Args:
        min_: the minimum integer
        max_: the maximum integer
        n: the number of integers to return

    Returns:
        a balanced set of integers
    """
    n_reps_float = n / (max_ - min_ + 1)
    if n_reps_float < 1:
        logger.warning(
            f"Cannot ensure each payload appears at least once as n={n} < {max_ - min_ + 1}"
        )
    values = list(range(min_, max_ + 1)) * ceil(n_reps_float)
    random.shuffle(values)
    return values[:n]
