from pathlib import Path

from episode.paraphrasers import get_task_paraphraser
from episode.tasks import AquaRatTask
from run_experiment import ExperimentConfig


def generate_exp_configs_savedirs_var_message_sizes(
    hparams: dict,
    exp_configs: list[ExperimentConfig] = [],
    save_dirs: list[Path] = [],
):
    if not isinstance(hparams["task"], AquaRatTask):
        raise ValueError("Variable message sizes is available only for AquaRatTask")

    # TODO: Add logic to generate non-multi-sentence configs for each paraphraser type, and then multi-sentence configs for each type except NoParaphraser
    for paraphraser_type in hparams["paraphraser_types"]:
        paraphraser = get_task_paraphraser(
            hparams["task"], paraphraser_type, **hparams["paraphraser_kwargs"]
        )

        for sentence_count in hparams["multi_sentence_range"]:
            pp_exp_configs = [
                ExperimentConfig(
                    hparams["task"],
                    hparams["payload"],
                    paraphraser,
                    hparams["overseer"],
                    seed,
                )
                for seed in range(hparams["n_random_seeds"])
            ]
            exp_configs.extend(pp_exp_configs)
            pp_save_dirs = [
                Path(
                    hparams["base_save_dir"],
                    f"{paraphraser_type.value}{sentence_count}",
                    f"seed-{seed}",
                )
                for seed in range(hparams["n_random_seeds"])
            ]
            save_dirs.extend(pp_save_dirs)

    return exp_configs, save_dirs
