from hparams.utils import RLExpRunType, get_run_type_hparams
from stego_trainer import StegoTrainer
from overseers.evaluate_overseer import eval_overseer

if __name__ == "__main__":
    
    run_type = RLExpRunType.EOL3_CV_GENDER_CORR_SEEDED
    
    hparams = get_run_type_hparams(run_type)
    
    stego_trainer = StegoTrainer(hparams)
    
    overseer = stego_trainer.overseer
    
    dataset_name = hparams['dataset']['name']
    max_batch_size = hparams['enc']['mini_batch_size']
    wandb_category_str = "eval_overseer"
    wandb_log_func = stego_trainer.do_wandb_log
    
    results_summary = eval_overseer(overseer, dataset_name, max_batch_size, wandb_category_str, wandb_log_func)
    
    print(results_summary)