import argparse
from hparams.utils import RLExpRunType
from stego_trainer import run_stego_trainer

if __name__ == "__main__":
    
    '''
    e.g., python run_stego_trainer.py --run_type DEBUG --exp_name_prefix debug
    
    '''
    
    # Get the list of run types dynamically from the enum
    run_type_choices = [rt.name for rt in RLExpRunType]
    
    parser = argparse.ArgumentParser(description="Run Stego Trainer with specified arguments")
    parser.add_argument("--run_type", type=str, choices=run_type_choices, help="Run type for the experiment")
    parser.add_argument("--exp_name_prefix", type=str, help="Prefix for the experiment name")
    parser.add_argument("--seed", type=int, default=None, help="Random seed for reproducibility")
    
    args = parser.parse_args()
    
    # Use TRAIN, DEBUG OR SANITY as required below (make sure to change the wandb_key and hf_key)
    run_stego_trainer(
        RLExpRunType[args.run_type],
        wandb_key="myWandbKey",
        hf_key="myHfKey",
        exp_name_prefix=args.exp_name_prefix,
        cmd_line_seed=args.seed,
    )