from serde import Serializable

from ..tasks.natural_task import NaturalTaskInstance
from .natural_decoder import NaturalDecoder


class NaturalDummyDecoder(NaturalDecoder):
    """Just return nothing for each input."""

    def get_output(self, task: NaturalTaskInstance, encoder_answer: str) -> str:
        """Attempt to decode the secret payload from the speaker's answer to the task

        Args:
            task: the task which the encoder was answering
            encoder_answer: the encoder's answer to the task

        Returns:
            the guess of the secret payload, or None if the model fails to produce a guess
        """

        return ""

    def serialize(self) -> dict[str, Serializable]:
        return {}
