from abc import abstractmethod

from ..tasks.natural_task import NaturalTaskInstance


class NaturalDecoder:
    @abstractmethod
    def get_output(self, task: NaturalTaskInstance, encoder_answer: str) -> str:
        """Get an output from the encoder's answer to the task

        Args:
            task: the task which the encoder was answering
            encoder_answer: the encoder's answer to the task

        Returns:
            the guess of the secret payload, or None if the model fails to produce a guess
        """
        pass
