from abc import abstractmethod
from typing import Optional

from serde import Serializable

from ..tasks import NaturalTaskInstance


class NaturalOverseerEvaluation:
    @abstractmethod
    def reject_episode(self) -> Optional[str]:
        """Decide whether the overseer wants to reject the episode or not."""
        pass

    @abstractmethod
    def serialize(self) -> dict[str, Serializable]:
        pass


class NaturalOverseer:
    """Takes the results of an experiment, and establishes if the is an obvious encoding scheme."""

    @abstractmethod
    def evaluate(
        self, messages: list[str], tasks: list[NaturalTaskInstance]
    ) -> NaturalOverseerEvaluation:
        pass

    def serialize(self) -> dict[str, Serializable]:
        return {}
