from abc import abstractmethod
from typing import Optional

from serde import Serializable

from ..payloads import Payload, PayloadInstance
from ..tasks import TaskInstance


class Decoder:
    def __init__(self, payload_type: Payload):
        self.payload_type = payload_type

    @abstractmethod
    def get_secret_payload(
        self, task: TaskInstance, encoder_answer: str
    ) -> Optional[PayloadInstance]:
        """Attempt to decode the secret payload from the speaker's answer to the task

        Args:
            task: the task which the encoder was answering
            encoder_answer: the encoder's answer to the task

        Returns:
            the guess of the secret payload, or None if the model fails to produce a guess
        """
        pass

    def serialize(self) -> Serializable:
        return {
            "payload_type": self.payload_type,
        }
