from dataclasses import dataclass
from typing import Optional


@dataclass
class EpisodeEvaluation:
    correct: bool
    reason: Optional[str] = None

    def __str__(self):
        if self.correct:
            return "CORRECT"
        else:
            return f"INCORRECT - {self.reason}"

    def __bool__(self):
        return self.correct
