import numpy as np

def readfile(fname):
    lines = open(fname, 'r').readlines()
    lines = [line.strip() for line in lines]
    return lines

def intomultirow(items, task_hs, width):
    items = [f'\\multirow{{{task_h}}}{{{width}}}{{{item}}}' for item,task_h in zip(items, task_hs)]
    return items

def generate_successes_failures(prefixes_file, predictions_file, targets_file, task_hs):
    width = '10em'

    task_names = 'Containers.Navigation Route.Navigation Result.Hard Object'.split('.')
    task_names = intomultirow(task_names, task_hs, '5em')

    prefixes = readfile(prefixes_file)
    prefixes = intomultirow(prefixes,task_hs,width)
    
    targets = readfile(targets_file)
    targets = intomultirow(targets,task_hs,width)

    predictions = readfile(predictions_file)
    predictions = intomultirow(predictions,task_hs,width)

    task_hs -=1
    c_nls = '&&&\\\\'*task_hs[0]
    n_nls = '&&&\\\\'*task_hs[1]
    nr_nls = '&&&\\\\'*task_hs[2]
    ho_nls = '&&&\\\\'*task_hs[3]


    template =f"""
\\begin{{longtable}}{{|c|c|c|c|}}


\\hline
Task Name                                                   & Prefix & Target & Prediction \\\\
\\hline
\\endfirsthead

\\multicolumn{{4}}{{l}}{{\\textit{{...continued from last page.}}}}\\\\
\\hline
Task Name & Prefix & Target & Prediction\\\\
\\hline
\\endhead

\\hline
\\multicolumn{{4}}{{|r|}}{{\\textit{{Continued on next page...}}}}\\\\
\\hline
\\endfoot

\\hline
\\endlastfoot




{task_names[0]}                                                   & {prefixes[0]}       & {targets[0]}       & {predictions[0]}           \\\\
{c_nls}
\\hline
{task_names[1]} & {prefixes[1]}       & {targets[1]}       & {predictions[1]}            \\\\
{n_nls}
\\pagebreak
{task_names[2]} & {prefixes[2]}       & {targets[2]}       & {predictions[2]}            \\\\
{nr_nls}
\\hline
{task_names[3]}                                              & {prefixes[3]}       & {targets[3]}       & {predictions[3]}           \\\\
{ho_nls}
\\hline
\\end{{longtable}}
    """
    print(template)

#Successes
#prefixes = 'results/sf/successes/prefixes.txt'
#targets = 'results/sf/successes/targets.txt'
#predictions = 'results/sf/successes/predictions.txt'
#tasks_hs = np.array([19,15,22,18])
#generate_successes_failures(prefixes, targets, predictions, tasks_hs)

prefixes = 'results/sf/failures/prefixes.txt'
targets = 'results/sf/failures/targets.txt'
predictions = 'results/sf/failures/predictions.txt'
tasks_hs = np.array([21,19,13,25])
generate_successes_failures(prefixes, targets, predictions, tasks_hs)
