
def generate_experiment(model_name, data_names):
    """
    Create a set of experiment directories named according to what model and what set of scenarios it will be tested on.
    """
    for data_name, data_dir, obj_name_file, cont_name_file in zip(data_names, data_dirs, obj_name_files, cont_name_files):

        experiment = "experiment-" + model_name + "-" + data_name
        tf.gfile.MakeDirs(os.path.join(f'experiments/{experiment}/testing/'))
        generate_range_of_scenarios(experiment = experiment, data_dir=data_dir, cont_name_file=cont_name_file,obj_name_file=obj_name_file)


if __name__=="__main__":
    models = """3Barc-challenge
                3Barc-easy
                3Bphysicaliqaprobs
                3Btom0
                3Btom10
                3Btomeasy0
                3Btomeasy10
                3Bwordprobs
                """.split()

    data_dirs = """
arcprobs/arc-challenge
arcprobs/arc-easy
physicaliqaprobs
tomprobs/tom0
tomprobs/tom10
tomprobs/tomeasy0
tomprobs/tomeasy10
wordprobs
    """.split()

    prefixes = """
prefixes-test.txt
prefixes-validation.txt

prefixes-test.txt
prefixes-validation.txt









prefixes-atr-train.txt
prefixes-atr-validation.txt
prefixes-fb_belief_test_test.txt
prefixes-fb_belief_val_test.txt
prefixes-fb_memory_test_test.txt
prefixes-fb_memory_val_test.txt
prefixes-fb_reality_test_test.txt
prefixes-fb_reality_val_test.txt
prefixes-fb_search_test_test.txt
prefixes-fb_search_val_test.txt
prefixes-qa21_task_AB_train.txt
prefixes-sofb_belief_test_test.txt
prefixes-sofb_belief_val_test.txt
prefixes-sofb_memory_test_test.txt
prefixes-sofb_memory_val_test.txt
prefixes-sofb_reality_test_test.txt
prefixes-sofb_reality_val_test.txt
prefixes-sofb_search_test_test.txt
prefixes-sofb_search_val_test.txt
prefixes-tb_belief_test_test.txt
prefixes-tb_belief_val_test.txt
prefixes-tb_memory_test_test.txt
prefixes-tb_memory_val_test.txt
prefixes-tb_reality_test_test.txt
prefixes-tb_reality_val_test.txt
prefixes-tb_search_test_test.txt
prefixes-tb_search_val_test.txt

    """.split()
    targets = """

    """.split()
    print(models)
