r"""
    From MaskDP https://github.com/FangchenLiu/MaskDP_public
    and RLKit https://github.com/rail-berkeley/rlkit/blob/master/rlkit/torch/pytorch_util.py
"""
import numpy as np
import torch

def soft_update_params(net, target_net, tau):
    for param, target_param in zip(net.parameters(), target_net.parameters()):
        target_param.data.copy_(tau * param.data + (1 - tau) * target_param.data)


def hard_update_params(net, target_net):
    for param, target_param in zip(net.parameters(), target_net.parameters()):
        target_param.data.copy_(param.data)


def from_numpy(*args, **kwargs):
    return torch.from_numpy(*args, **kwargs).float()

def get_numpy(tensor):
    return tensor.to('cpu').detach().numpy()
