from setuptools import setup, find_packages

setup(
    name='context_general_bci',
    version='0.0.1',

    url='https://github.com/REDACT/context_general_bci',
    author='REDACT Ye',
    author_email='REDACT@gmail.com',

    packages=find_packages(exclude=['scripts', 'crc_scripts', 'data', 'data_scripts', 'slurm']),
    py_modules=['context_general_bci'],

    install_requires=[
        'torch==2.1.0+cu118', # 2.0 onnx export doesn't work, install with --extra-index-url https://download.pytorch.org/whl/cu117
        'seaborn',
        'pandas',
        'numpy',
        'scipy',
        'onnxruntime-gpu',
        'pyrtma',
        'hydra-core',
        'yacs',
        'pynwb',
        'argparse',
        'wandb',
        'einops',
        'lightning',
        'scikit-learn',
        'ordered-enum',
        'mat73',
        'dacite',
        'gdown',
        'timm',
        'pyrtma', # For realtime REDACT infra
        'transformers', # Flash Attn
        'peft',
        'packaging', # Flash Attn https://github.com/Dao-AILab/flash-attention
        'rotary-embedding-torch', # https://github.com/lucidrains/rotary-embedding-torch
        'sentencepiece', # Flash Attn
        'tensordict',
        'edit-distance',
        'falcon-challenge',
        'ruamel.yaml',
        # 'flash-attn', # install following build instructions on https://github.com/Dao-AILab/flash-attention
        # Add nvcc corresponding to torch (module system on cluster, cuda/11.8)
        # -- export CUDA_HOME=/ihome/crc/install/cuda/11.8
        # pip install flash-attn --no-build-isolation
    ],
)