# B4MRL
Data and simulators for hybrid online-offline-RL tasks.

1. The simulators are biased by predetermined options.
2. The data is biased by predetermined options.

To create an instance of the required env make sure first register all envs by:
```
import b4mrl
```

Steps to create an biased environment:
1. Run gym.make on an environment with a specific dataset
For example, creating a HalfCheetah environment with medium dataset by running:
```
gym.make('halfcheetah-medium-v2')
```
We add several other options for different datasets
```
halfcheetah-ds-obs-hidden-dims-9
halfcheetah-ds-obs-hidden-dims-9-stacked-3
halfcheetah-ds-obs-hidden-dims-163333333
halfcheetah-ds-obs-hidden-dims-16-stacked-3
```
To be able to run these added environments, please first download them from the anonymized one-drive links below:

https://1drv.ms/f/s!Ah0CJrMl_CR5aWFOrFlTkszgWFA?e=6tFfWp
https://1drv.ms/f/s!Ah0CJrMl_CR5ajSX_rJ8SRuFv9M?e=xNinha
https://1drv.ms/f/s!Ah0CJrMl_CR5a7MokfQqBMj3YrA?e=bnZ9b3
https://1drv.ms/f/s!Ah0CJrMl_CR5bEKnpytXfaEr6cM?e=btRyFC

After downloading, please move all the downloaded folders to the data folder, and then gym.make with the above ids should work.

For creating an environment with transition error (which we also name modeling error in the paper), first make sure the xml file is in the xmls directory.
The environment needs to be made with the specific transition error necessary in between the name of the dataset and the version.
For example:
```
gym.make('halfcheetah-medium-transition-error-gravity-2-v2')
```

To add another error to the model (observation error, hidden variables, etc.), run the given function and specify exactly what discrepancies needed.
It should be given as list of tuples of type and amount.
For example, the environment above can be ran with variable 9 hidden in the dataset:
```
env_name = 'halfcheetah-medium-transition-error-gravity-2-v2'
env = b4mrl.get_transformed_env(env_name, ['ds-hidden-dims', 9])
```
The function creates the new environment by running gym.make by itself. 