import datetime

from yacs.config import CfgNode as CN

_C = CN()

# General settings
_C.save_model = True
_C.agent_path = 'H2O/agents/'

# WANDB settings
_C.wandb = CN()
_C.wandb.enable = True
_C.wandb.project_name = ''
_C.wandb.name = ''

_C.data = CN()
_C.data.path = ''
_C.data.use_d4rl = True
_C.data.noise_coeff = 0.0

# Simulator model args
_C.simulator = CN()
_C.simulator.xml_path = 'sim_envs/xmls/halfcheetah/default.xml'
_C.simulator.noise_coeff = 0.0
_C.simulator.type = 'halfcheetah_transition_error'
_C.simulator.data_path = ''
_C.simulator.decimals = 32
_C.simulator.clip_obs = True

# System parameters
_C.system = CN()
_C.system.seed = 11
_C.system.cpu = False

# Environment
_C.env = CN()
_C.env.type = ''

# Algorithm params
_C.algorithm = CN()
_C.algorithm.current_time = datetime.datetime.now().strftime('%y-%m-%d-%H-%M-%S')
_C.algorithm.name_str = ''
_C.algorithm.batch_ratio = 0.5
_C.algorithm.replaybuffer_ratio = 10
_C.algorithm.real_residual_ratio = 1.0
_C.algorithm.dis_dropout = False
_C.algorithm.max_traj_length = 1000
_C.algorithm.seed = 42
_C.algorithm.save_model = False
_C.algorithm.batch_size = 256

_C.algorithm.reward_scale = 1.0
_C.algorithm.reward_bias = 0.0
_C.algorithm.clip_action = 1.0
_C.algorithm.joint_noise_std = 0.0

_C.algorithm.policy_arch = '256-256'
_C.algorithm.qf_arch = '256-256'
_C.algorithm.orthogonal_init = False
_C.algorithm.policy_log_std_multiplier = 1.0
_C.algorithm.policy_log_std_offset = -1.0

# train and evaluate policy
_C.algorithm.n_epochs = 1000
_C.algorithm.bc_epochs = 0
_C.algorithm.n_rollout_steps_per_epoch = 1000
_C.algorithm.n_train_step_per_epoch = 1000
_C.algorithm.eval_period = 10
_C.algorithm.eval_n_trajs = 5


def get_cfg_defaults(config_file=None, config_list=None):
    cfg = _C.clone()
    if config_file is not None:
        cfg.merge_from_file(config_file)
    if config_list is not None:
        cfg.merge_from_list(config_list)
    cfg.freeze()
    return cfg
